package rcon.commands;


public class YellCommand extends ClientRequest {
	
	public static final int DEFAULT_TIMEOUT = 10000;
	
	/*
	 * PUBLIC YELL
	 */
	public YellCommand(String text) {
		this(text, DEFAULT_TIMEOUT);
	}
	public YellCommand(String text, int timeout) {
		super("admin.yell", text, String.valueOf(timeout), "all");
	}
	
	/*
	 * PRIVATE YELL
	 */
	public YellCommand(String text, String player) {
		this(text, DEFAULT_TIMEOUT, player);
	}
	public YellCommand(String text, int timeout, String player) {
		super("admin.yell", text, String.valueOf(timeout), "player", player);
	}
	
}
