package rcon.database;

import java.sql.Connection;
import java.sql.SQLException;

import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDataSource;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.apache.log4j.Logger;

import rcon.log.LogDatabase;
import rcon.players.AdminDatabase;
import rcon.players.PlayerDatabase;
import rcon.players.PunishmentDatabase;
import rcon.players.ReportDatabase;
import rcon.players.StatsDatabase;

public class Database {
	static Logger					logger	= Logger.getLogger(Database.class);
	private PoolingDataSource		dataSource;
	
	public final PlayerDatabase		players;
	public final AdminDatabase		admins;
	public final PunishmentDatabase	bans;
	public final LogDatabase		logs;
	public final StatsDatabase		stats;
	public final ReportDatabase		reports;
	
	public Database(String id, String driver, String url, String user, String password) throws SQLException {
		try {
			Class.forName(driver);
		} catch(Exception e) {
			throw new SQLException("Failed to load JDBC driver.", e);
		}
		
		ObjectPool connectionPool = new GenericObjectPool(null);
		ConnectionFactory connectionFactory = new DriverManagerConnectionFactory(url, user, password);
		new PoolableConnectionFactory(connectionFactory, connectionPool, null, null, false, true);
		dataSource = new PoolingDataSource(connectionPool);
		
		players = new PlayerDatabase(this, id);
		admins = new AdminDatabase(this, id);
		bans = new PunishmentDatabase(this, id);
		logs = new LogDatabase(this, id);
		stats = new StatsDatabase(this, id);
		reports = new ReportDatabase(this, id);
	}
	
	protected Connection getConnection() throws SQLException {
		return dataSource.getConnection();
	}
}
