package rcon.event;

import java.sql.SQLException;

import org.apache.log4j.Logger;

import rcon.database.Database;
import rcon.players.Player;
import rcon.players.PlayerInfo;

public class DatabaseSynchronizationHandler extends RCONEventAdapter {
	
	static Logger		logger	= Logger.getLogger(DatabaseSynchronizationHandler.class);
	private Database	db;
	
	public DatabaseSynchronizationHandler(Database db) {
		this.db = db;
	}
	
	@Override
	public void onPbInfo(Player player, String guid, String ip) {
		sync(player);
	}
	
	@Override
	public void onAuthenticated(Player player) {
		sync(player);
	}
	
	@Override
	public void onJoin(Player player, String eaGuid) {
		sync(player);
	}
	
	@Override
	public void onPlayerInfo(Player player, PlayerInfo oldInfo, PlayerInfo info) {
		if(!oldInfo.getEaGuid().equals(info.getEaGuid())) {
			sync(player);
		}
	}
	
	private void sync(Player player) {
		try {
			db.players.update(player);
		} catch(SQLException e) {
			logger.error("Failed to synchronized player with database.", e);
		}
	}
	
}
