package rcon.event;

import java.util.HashSet;

import rcon.players.Player;
import rcon.server.GameServer;

public class KDNotificationHandler extends RCONEventAdapter {
	
	private GameServer		server;
	private double			kd;
	private int				minKills;
	private HashSet<String>	cache;
	
	public KDNotificationHandler(GameServer server, double kd, int minKills) {
		this.server = server;
		this.kd = kd;
		this.minKills = minKills;
		this.cache = new HashSet<String>();
	}
	
	@Override
	public void onKill(Player killer, Player killed, String weapon, boolean headshot) {
		int kills = killer.getInfo().getKills() + 1;
		int deaths = killer.getInfo().getDeaths();
		double currentKd = deaths == 0 ? kills : ((double)kills) / deaths;
		if(kills >= minKills && currentKd >= kd) {
			if(!cache.contains(killer.getName())) {
				for(Player admin : server.getOnline().getAdmins()) {
					server.say("Player " + killer.getName() + " has a K/D ratio of " + kills + "/" + deaths + ".",
						admin);
				}
				cache.add(killer.getName());
			}
		}
	}
	
	@Override
	public void onLevelStarted() {
		cache.clear();
	}
	
}
