package rcon.event;

import rcon.map.Map;
import rcon.map.Maps;
import rcon.map.Playlist;
import rcon.server.GameServer;

public class MapHandler extends RCONEventAdapter {
	
	private Maps			maps;
	private GameServer		server;
	private Playlist.Entry	last;
	
	public MapHandler(GameServer server, Maps maps) {
		this.server = server;
		this.maps = maps;
		last = null;
	}
	
	@Override
	public void onLevelStarted() {
		
	}
	
	@Override
	public void onLevelLoaded(String level, String gameMode, int roundsPlayed, int roundsTotal) {
		if(roundsPlayed >= roundsTotal) {
			Playlist.Entry next = maps.getPlaylist().getNext(last);
			if(next != null) {
				Map map = next.getMap();
				server.setPlaylist(map.getMode().getPlaylist());
				server.clearMapList();
				server.appendMap(map, next.getRounds());
				server.setNextMapIndex(0);
			}
		}
	}
	
}
