package rcon.event;

import java.util.ArrayList;

import rcon.players.Player;
import rcon.players.PlayerInfo;

public interface RCONEventHandler {
	
	public void onJoin(Player player, String eaGuid);
	
	public void onLeave(Player player, PlayerInfo info);
	
	public void onKill(Player killer, Player killed, String weapon, boolean headshot);
	
	public void onChat(Player player, String message);
	
	public void onPbInfo(Player player, String guid, String ip);
	
	public void onPunkbuster(String message);
	
	public void onLevelStarted();
	
	public void onLevelLoaded(String level, String gameMode, int roundsPlayed, int roundsTotal);
	
	public void onSquadChange(Player p, int team, int squad);
	
	public void onTeamChange(Player p, int team, int squad);
	
	public void onKicked(Player p, String reason);
	
	public void onAuthenticated(Player p);
	
	public void onPlayerInfo(Player p, PlayerInfo oldInfo, PlayerInfo info);
	
	public void onSpawn(Player p, boolean first);
	
	public void onRoundOverPlayers(ArrayList<PlayerInfo> info);
	
}
