package rcon.event;

import rcon.players.Player;
import rcon.server.GameServer;

public class StreakHandler extends RCONEventAdapter {
	
	private GameServer	server;
	private int			modulus;
	private int			bigLimit;
	
	public StreakHandler(GameServer server, int modulus, int bigLimit) {
		this.server = server;
		this.modulus = modulus;
		this.bigLimit = bigLimit;
	}
	
	@Override
	public void onKill(Player killer, Player killed, String weapon, boolean headshot) {
		if(killer.getInfo().getTeam() != killed.getInfo().getTeam()) {
			int killerStreak = killer.incrementStreak();
			if(killerStreak != 0 && killerStreak % modulus == 0) {
				StringBuilder sb = new StringBuilder();
				sb.append(killer.getName());
				sb.append(" is on a kill streak of ");
				sb.append(killerStreak);
				sb.append(" kills.");
				server.say(sb.toString());
			}
		}
		
		int killedStreak = killed.getKillStreak();
		killed.resetStreak();
		
		if(killedStreak >= modulus) {
			StringBuilder sb = new StringBuilder();
			sb.append(killer.getName());
			sb.append(" ended ");
			if(killer.equals(killed)) {
				sb.append("his own kill streak of ");
			} else {
				sb.append(killed.getName());
				sb.append("'s kill streak of ");
			}
			sb.append(killedStreak);
			sb.append(" kills.");
			server.say(sb.toString());
		}
		
	}
	
	@Override
	public void onSpawn(Player p, boolean first) {
		p.resetStreak();
	}
	
}
