package rcon.ingame;

import java.util.EnumSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import rcon.players.Right;

public enum InGameCommand {
	nextMap("!nextmap", "^!nextmap\\s*$", "!nextmap", Right.inGame, Right.runNextMap),
	restart("!restart", "^!restart\\s*$", "!restart", Right.inGame, Right.restartMap),
	report("!report", "^!report\\s*(.*)", "!report <message to admins>", Right.report),
	whisper("!whisper",
			"^!whisper\\s+([^,]+)\\s*,\\s*(.+)\\s*$",
			"!whisper <player name>, <message>",
			Right.inGame,
			Right.whisper),
	kill("!kill", "^!kill\\s+(.*)\\s*$", "!kill <player name>", Right.inGame, Right.kill),
	warn("!w", "^!w\\s+([^,]+)\\s*,\\s*(.+)\\s*$", "!w <player name>, <reason>", Right.inGame, Right.warn),
	kick("!k", "^!k\\s+([^,]+)\\s*,\\s*(.+)\\s*$", "!k <player name>, <reason>", Right.inGame, Right.kick),
	ban("!b",
			"^!b\\s+([^,]+)\\s*,\\s*(.+)\\s*,\\s*(\\S+)\\s*$",
			"!b <player name>, <reason>, <duration>",
			Right.inGame,
			Right.ban),
	adminChat("!a", "^!a\\s+(.*)\\s*$", "!a <message>", Right.inGame, Right.adminChat),
	yell("!s", "^!s\\s+(.*)\\s*$", "!s <message>", Right.inGame, Right.yell),
	history("!h", "^!h\\s+(.*)\\s*$", "!h <player name>", Right.inGame, Right.playerHistory),
	rank("!rank", "^!rank\\s*$", "!rank", Right.rank),
	pb("!pb", "^!pb\\s*(.*)\\s*$", "!pb <command>", Right.inGame, Right.pbAdmin);
	
	private String			command;
	private Pattern			pattern;
	private String			syntax;
	private EnumSet<Right>	rights;
	
	private InGameCommand(String command, String regexp, String syntax, Right right, Right... rights) {
		this.command = command;
		this.pattern = Pattern.compile(regexp);
		this.syntax = syntax;
		this.rights = EnumSet.of(right, rights);
	}
	
	private InGameCommand(String command, String regexp, String syntax) {
		this.command = command;
		this.pattern = Pattern.compile(regexp);
		this.syntax = syntax;
		rights = EnumSet.noneOf(Right.class);
	}
	
	public Matcher match(String text) {
		return pattern.matcher(text);
	}
	
	public String getSyntax() {
		return syntax;
	}
	
	public boolean hasRights(EnumSet<Right> rights) {
		return rights.containsAll(this.rights);
	}
	
	public static InGameCommand get(String message) {
		for(InGameCommand cmd : InGameCommand.values()) {
			if(message.startsWith(cmd.command)) {
				return cmd;
			}
		}
		return null;
	}
}
