package rcon.log;

import java.sql.SQLException;

import rcon.database.Database;
import rcon.event.RCONEventAdapter;
import rcon.players.Player;

public class ChatLogHandler extends RCONEventAdapter {
	
	private Database	database;
	
	public ChatLogHandler(Database database) {
		this.database = database;
	}
	
	@Override
	public void onChat(Player player, String message) {
		try {
			database.logs.chat(player.getName(), "chat", message);
		} catch(SQLException e) {
			e.printStackTrace();
		}
	}
	
}
