package rcon.map;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Playlist {
	public static class Entry {
		private final Map	map;
		private final int	rounds;
		
		private Entry(Map map, int rounds) {
			this.map = map;
			this.rounds = rounds;
		}
		
		public Map getMap() {
			return map;
		}
		
		public int getRounds() {
			return rounds;
		}
	}
	
	private final List<Entry>	playlist;
	
	public Playlist() {
		playlist = new ArrayList<Entry>();
	}
	
	public synchronized void append(Map map, int rounds) {
		playlist.add(new Entry(map, rounds));
	}
	
	public synchronized void insert(int index, Map map, int rounds) {
		playlist.add(index, new Entry(map, rounds));
	}
	
	public synchronized void remove(int index) {
		playlist.remove(index);
	}
	
	public synchronized Entry get(int index) {
		return playlist.get(index);
	}
	
	public synchronized List<Entry> get() {
		return new ArrayList<Entry>(playlist);
	}
	
	public synchronized int size() {
		return playlist.size();
	}
	
	public synchronized void clear() {
		playlist.clear();
	}
	
	public synchronized Entry getNext(Entry previous) {
		if(playlist.isEmpty()) {
			return null;
		}
		Iterator<Entry> it = playlist.iterator();
		while(it.hasNext()) {
			Entry next = it.next();
			if(next == previous) {
				if(it.hasNext()) {
					return it.next();
				} else {
					return playlist.get(0);
				}
			}
		}
		return playlist.get(0);
	}
	
}
