package rcon.net;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

import org.apache.log4j.Logger;

import rcon.MessageType;
import rcon.commands.Command;

public class RCONOutputStream {
	
	static Logger					logger	= Logger.getLogger(RCONOutputStream.class);
	
	private ByteArrayOutputStream	bout;
	private OutputStream			out;
	
	public RCONOutputStream(OutputStream out) {
		this.bout = new ByteArrayOutputStream();
		this.out = new BufferedOutputStream(out);
	}
	
	private void writeWord(String string) throws IOException {
		writeInt(bout, string.length());
		bout.write(string.getBytes("US-ASCII"));
		bout.write('\0');
	}
	
	public synchronized void sendCommand(Command command) throws IOException {
		int words = command.size() + 1;
		writeInt(bout, words);
		writeWord(command.getName());
		for(String argument : command.getArguments()) {
			writeWord(argument);
		}
		
		writeHeader(command.getSeq(), command.getType());
		
		out.flush();
		bout.reset();
		
		logger.trace("-> " + command);
	}
	
	private void writeHeader(int sequence, MessageType type) throws IOException {
		writeInt(out, sequence | type.flags);
		writeInt(out, bout.size() + 4 + 4);
		out.write(bout.toByteArray());
	}
	
	private void writeInt(OutputStream out, long value) throws IOException {
		out.write((int)(value & 0x000000FFL));
		out.write((int)((value & 0x0000FF00L) >> 8));
		out.write((int)((value & 0x00FF0000L) >> 16));
		out.write((int)((value & 0xFF000000L) >> 24));
	}
	
}
