package rcon.players;

import java.util.EnumSet;

public class Admin {
	private int				id;
	private String			guid;
	private String			userName;
	private String			password;
	private EnumSet<Right>	rights;
	
	public Admin(int id, String guid, String userName, String password, EnumSet<Right> rights) {
		this.id = id;
		this.guid = guid;
		this.userName = userName;
		this.password = password;
		this.rights = EnumSet.copyOf(rights);
	}
	
	public int getId() {
		return id;
	}
	
	public String getGuid() {
		return guid;
	}
	
	public String getUserName() {
		return userName;
	}
	
	public String getPassword() {
		return password;
	}
	
	public boolean hasRight(Right right) {
		return rights.contains(right);
	}
	
	public EnumSet<Right> getRights() {
		return EnumSet.copyOf(rights);
	}
	
	public void setRights(EnumSet<Right> rights) {
		this.rights = EnumSet.copyOf(rights);
	}
	
	public void setPassword(String password) {
		this.password = password;
	}
	
	public void setId(int id) {
		this.id = id;
	}
	
	public void setGuid(String guid) {
		this.guid = guid;
	}
	
	@Override
	public String toString() {
		return id + " " + userName + ": " + guid + ". (" + Right.toString(rights) + ").";
	}
	
}
