package rcon.players;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

import rcon.database.Database;
import rcon.database.DatabaseModule;

public class AdminDatabase extends DatabaseModule {
	
	public AdminDatabase(Database database, String id) {
		super(database, id);
	}
	
	public Admin get(String username) throws SQLException {
		Connection con = getConnection();
		PreparedStatement stmt = null;
		ResultSet result = null;
		try {
			stmt = con.prepareStatement("SELECT * FROM admins WHERE username = ?");
			stmt.setString(1, username);
			result = stmt.executeQuery();
			if(result.next()) {
				return parse(result);
			} else {
				return null;
			}
		} finally {
			close(con, stmt, result);
		}
	}
	
	public Admin get(int id) throws SQLException {
		Connection con = getConnection();
		PreparedStatement stmt = null;
		ResultSet result = null;
		try {
			stmt = con.prepareStatement("SELECT * FROM admins WHERE id = ?");
			stmt.setInt(1, id);
			result = stmt.executeQuery();
			if(result.next()) {
				return parse(result);
			} else {
				return null;
			}
		} finally {
			close(con, stmt, result);
		}
	}
	
	public Admin getByGuid(String guid) throws SQLException {
		Connection con = getConnection();
		PreparedStatement stmt = null;
		ResultSet result = null;
		try {
			stmt = con.prepareStatement("SELECT * FROM admins WHERE guid = ?");
			stmt.setString(1, guid);
			result = stmt.executeQuery();
			if(result.next()) {
				return parse(result);
			} else {
				return null;
			}
		} finally {
			close(con, stmt, result);
		}
	}
	
	public boolean save(Admin admin) throws SQLException {
		Connection con = getConnection();
		PreparedStatement stmt = null;
		ResultSet result = null;
		try {
			stmt = con
				.prepareStatement("UPDATE admins SET guid = ?, username = ?, password = ?, rights = ? WHERE id = ?");
			stmt.setString(1, admin.getGuid());
			stmt.setString(2, admin.getUserName());
			stmt.setString(3, admin.getPassword());
			stmt.setString(4, Right.toString(admin.getRights()));
			stmt.setInt(5, admin.getId());
			
			return stmt.executeUpdate() == 1;
		} finally {
			close(con, stmt, result);
		}
	}
	
	public boolean create(Admin admin) throws SQLException {
		Connection con = getConnection();
		PreparedStatement stmt = null;
		ResultSet keys = null;
		try {
			stmt = con.prepareStatement("INSERT INTO admins (guid, username, password, rights) VALUES(?, ?, ?, ?)",
				PreparedStatement.RETURN_GENERATED_KEYS);
			stmt.setString(1, admin.getGuid());
			stmt.setString(2, admin.getUserName());
			stmt.setString(3, admin.getPassword());
			stmt.setString(4, Right.toString(admin.getRights()));
			if(stmt.executeUpdate() == 1) {
				keys = stmt.getGeneratedKeys();
				if(keys.next()) {
					int id = keys.getInt(1);
					admin.setId(id);
					return true;
				}
			}
			return false;
		} finally {
			close(con, stmt, keys);
		}
	}
	
	public ArrayList<Admin> getAll() throws SQLException {
		Connection con = getConnection();
		PreparedStatement stmt = null;
		ResultSet result = null;
		try {
			stmt = con.prepareStatement("SELECT * FROM admins");
			
			ArrayList<Admin> admins = new ArrayList<Admin>();
			result = stmt.executeQuery();
			while(result.next()) {
				admins.add(parse(result));
			}
			return admins;
		} finally {
			close(con, stmt, result);
		}
	}
	
	public Admin parse(ResultSet result) throws SQLException {
		int adminId = result.getInt("admins.id");
		String adminGuid = result.getString("admins.guid");
		String adminUsername = result.getString("admins.username");
		String adminPassword = result.getString("admins.password");
		String rightsString = result.getString("admins.rights");
		String[] rights = rightsString.split(" ");
		
		Admin admin = new Admin(adminId, adminGuid, adminUsername, adminPassword, Right.parseRights(rights));
		return admin;
	}
	
}
