package rcon.players;

import java.util.Calendar;

public class Player {
	
	private final String	name;
	private String			pbGuid;
	private String			ip;
	private int				id;
	private Admin			admin;
	
	private PlayerInfo		info;
	private long			lastUpdate;
	private long			created;
	private int				killStreak;
	private boolean			hasSpawned;
	private Report			activeReport;
	
	public Player(String name) {
		this.name = name;
		pbGuid = "";
		ip = "";
		id = 0;
		admin = null;
		info = new PlayerInfo();
		lastUpdate = 0;
		created = Calendar.getInstance().getTimeInMillis() / 1000;
		killStreak = 0;
		hasSpawned = false;
		activeReport = null;
	}
	
	public Player(int id, String name, String eaGuid, String pbGuid, String ip) {
		this(name);
		this.pbGuid = pbGuid;
		this.ip = ip;
		this.id = id;
		info = new PlayerInfo(name, eaGuid);
	}
	
	public String getName() {
		return name;
	}
	
	public synchronized String getFullName() {
		return info.getClanTag().isEmpty() ? name : info.getClanTag() + " " + name;
	}
	
	public synchronized String getTag() {
		return info.getClanTag();
	}
	
	public synchronized String getPbGuid() {
		return pbGuid;
	}
	
	public synchronized void setPbGuid(String pbGuid) {
		this.pbGuid = pbGuid;
	}
	
	public synchronized String getIp() {
		return ip;
	}
	
	public synchronized void setIp(String ip) {
		this.ip = ip;
	}
	
	public synchronized int getId() {
		return id;
	}
	
	public synchronized void setId(int id) {
		this.id = id;
	}
	
	public synchronized Admin getAdmin() {
		return admin;
	}
	
	public synchronized void setAdmin(Admin admin) {
		this.admin = admin;
	}
	
	public synchronized boolean isAdmin() {
		return admin != null;
	}
	
	public synchronized void update(PlayerInfo info) {
		if(!name.equals(info.getName())) {
			throw new IllegalArgumentException("Player info does not match player.");
		}
		this.info = info;
	}
	
	public synchronized String getEaGuid() {
		return info.getEaGuid();
	}
	
	public synchronized void setEaGuid(String eaGuid) {
		info = info.eaGuid(eaGuid);
	}
	
	@Override
	public synchronized String toString() {
		return getFullName() + ": " + getEaGuid() + ", " + getPbGuid() + ", " + getIp() + ".";
	}
	
	public synchronized PlayerInfo getInfo() {
		return info;
	}
	
	public synchronized void onUpdated() {
		lastUpdate = System.currentTimeMillis();
	}
	
	public synchronized long getLastUpdate() {
		return lastUpdate;
	}
	
	public synchronized long getCreated() {
		return created;
	}
	
	public synchronized int incrementStreak() {
		return ++killStreak;
	}
	
	public synchronized void resetStreak() {
		killStreak = 0;
	}
	
	public synchronized int getKillStreak() {
		return killStreak;
	}
	
	public synchronized void spawn() {
		hasSpawned = true;
	}
	
	public synchronized boolean hasSpawned() {
		return hasSpawned;
	}
	
	public synchronized Report getActiveReport() {
		return activeReport;
	}
	
	public synchronized void setActiveReport(Report activeReport) {
		this.activeReport = activeReport;
	}
	
}
