package rcon.players;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

import rcon.database.Database;
import rcon.database.DatabaseModule;

public class PlayerDatabase extends DatabaseModule {
	
	public PlayerDatabase(Database database, String id) {
		super(database, id);
	}
	
	public void deleteAll() throws SQLException {
		Connection con = getConnection();
		PreparedStatement stmt = null;
		ResultSet result = null;
		try {
			stmt = con.prepareStatement("DELETE FROM players WHERE TRUE");
			stmt.executeUpdate();
		} finally {
			close(con, stmt, result);
		}
	}
	
	public void update(Player player) throws SQLException {
		Connection con = getConnection();
		PreparedStatement stmt = null;
		ResultSet result = null;
		try {
			String query = "INSERT INTO players (name, pbguid, eaguid) VALUES(?, ?, ?) ON duplicate KEY UPDATE id=LAST_INSERT_ID(id), name = ?";
			if(!player.getPbGuid().isEmpty()) {
				query += ", pbguid = ?";
			}
			if(!player.getEaGuid().isEmpty()) {
				query += ", eaguid = ?";
			}
			stmt = con.prepareStatement(query, PreparedStatement.RETURN_GENERATED_KEYS);
			
			int i = 1;
			stmt.setString(i++, player.getName());
			stmt.setString(i++, player.getPbGuid());
			stmt.setString(i++, player.getEaGuid());
			stmt.setString(i++, player.getName());
			if(!player.getPbGuid().isEmpty()) {
				stmt.setString(i++, player.getPbGuid());
			}
			if(!player.getEaGuid().isEmpty()) {
				stmt.setString(i++, player.getEaGuid());
			}
			stmt.executeUpdate();
			result = stmt.getGeneratedKeys();
			if(result.next()) {
				int id = result.getInt(1);
				player.setId(id);
			}
		} finally {
			close(con, stmt, result);
		}
		if(!player.getEaGuid().trim().isEmpty()) {
			Admin admin = database.admins.getByGuid(player.getEaGuid());
			if(admin != null) {
				player.setAdmin(admin);
			}
		}
	}
	
	public ArrayList<Player> find(String string, int offset, int limit) throws SQLException {
		Connection con = getConnection();
		PreparedStatement stmt = null;
		ResultSet result = null;
		try {
			// POSSIBLY SLOW
			/*
			 * stmt = con.prepareStatement(
			 * "SELECT * FROM players WHERE NOT POSITION(LCASE(?) IN LCASE(players.name)) = 0 ORDER BY players.name ASC LIMIT ? OFFSET ?"
			 * );
			 */
			stmt = con
				.prepareStatement("SELECT * FROM players WHERE players.name LIKE ? ORDER BY players.name ASC LIMIT ? OFFSET ?");
			// stmt.setString(1, string);
			stmt.setString(1, string + "%");
			stmt.setInt(2, limit);
			stmt.setInt(3, offset);
			ArrayList<Player> players = new ArrayList<Player>();
			result = stmt.executeQuery();
			while(result.next()) {
				players.add(parse(result));
			}
			return players;
		} finally {
			close(con, stmt, result);
		}
	}
	
	private Player parse(ResultSet result) throws SQLException {
		int id = result.getInt("players.id");
		String name = result.getString("players.name");
		String eaGuid = result.getString("players.eaguid");
		String pbGuid = result.getString("players.pbguid");
		String ip = "";// result.getString("players.ip");
		return new Player(id, name, eaGuid, pbGuid, ip);
	}
	
}
