package rcon.players;

import java.util.ArrayList;

import rcon.commands.Command;

public class PlayerInfo {
	
	private static enum Parameter {
		clanTag, name, guid, teamId, squadId, kills, deaths, score, ping, unknown;
	}
	
	private String	clanTag;
	private String	name;
	private String	eaGuid;
	private int		team;
	private int		squad;
	private int		kills;
	private int		deaths;
	private int		score;
	private int		ping;
	
	public PlayerInfo() {
		clanTag = "";
		name = "";
		eaGuid = "";
		team = 0;
		squad = 0;
		kills = 0;
		deaths = 0;
		score = 0;
		ping = 0;
	}
	
	public PlayerInfo(String name, String eaGuid) {
		this();
		this.name = name;
		this.eaGuid = eaGuid;
	}
	
	public PlayerInfo(PlayerInfo i) {
		clanTag = i.clanTag;
		name = i.name;
		eaGuid = i.eaGuid;
		team = i.team;
		squad = i.squad;
		kills = i.kills;
		deaths = i.deaths;
		score = i.score;
		ping = i.ping;
	}
	
	public static ArrayList<PlayerInfo> parse(Command command) {
		return parseInternal(command, 0);
	}
	
	public static PlayerInfo parseSingle(Command command) {
		ArrayList<PlayerInfo> info = parseInternal(command, 1);
		if(info.isEmpty()) {
			return null;
		} else {
			return info.get(0);
		}
	}
	
	private static ArrayList<PlayerInfo> parseInternal(Command command, int offset) {
		ArrayList<PlayerInfo> players = new ArrayList<PlayerInfo>();
		int paramCount = command.getInt(offset++);
		
		Parameter[] parameters = new Parameter[paramCount];
		for(int j = 0; j < paramCount; j++) {
			try {
				parameters[j] = Enum.valueOf(Parameter.class, command.get(offset++));
			} catch(IllegalArgumentException e) {
				parameters[j] = Parameter.unknown;
			}
		}
		
		int playerCount = command.getInt(offset++);
		
		for(int j = 0; j < playerCount; j++) {
			PlayerInfo player = new PlayerInfo();
			for(Parameter p : parameters) {
				switch(p) {
					case clanTag:
						player.clanTag = command.get(offset);
						break;
					case deaths:
						player.deaths = command.getInt(offset);
						break;
					case guid:
						player.eaGuid = command.get(offset);
						break;
					case kills:
						player.kills = command.getInt(offset);
						break;
					case name:
						player.name = command.get(offset);
						break;
					case ping:
						player.ping = command.getInt(offset);
						break;
					case score:
						player.score = command.getInt(offset);
						break;
					case squadId:
						player.squad = command.getInt(offset);
						break;
					case teamId:
						player.team = command.getInt(offset);
						break;
					case unknown:
						break;
				}
				offset++;
			}
			players.add(player);
		}
		
		return players;
	}
	
	public String getClanTag() {
		return clanTag;
	}
	
	public String getName() {
		return name;
	}
	
	public String getEaGuid() {
		return eaGuid;
	}
	
	public int getTeam() {
		return team;
	}
	
	public int getSquad() {
		return squad;
	}
	
	public int getKills() {
		return kills;
	}
	
	public int getDeaths() {
		return deaths;
	}
	
	public int getScore() {
		return score;
	}
	
	public int getPing() {
		return ping;
	}
	
	public PlayerInfo eaGuid(String eaGuid) {
		PlayerInfo ret = new PlayerInfo(this);
		ret.eaGuid = eaGuid;
		return ret;
	}
	
}
