package rcon.players;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import rcon.database.Database;
import rcon.database.DatabaseModule;

public class ReportDatabase extends DatabaseModule {
	
	public ReportDatabase(Database database, String id) {
		super(database, id);
	}
	
	public void abandon(Report report) throws SQLException {
		if(changeType(report, "live", "abandoned")) {
			addUpdate(report, "abandoned");
		}
	}
	
	public void comment(Report report, String comment) throws SQLException {
		addComment(report, comment);
		refresh(report);
	}
	
	public Report submitReport(Player player, String summary, String description) throws SQLException {
		Connection con = getConnection();
		PreparedStatement stmt = null;
		ResultSet result = null;
		try {
			stmt = con.prepareStatement("INSERT INTO reports VALUES(0, ?, NULL, "
					+ "UNIX_TIMESTAMP(NOW()), UNIX_TIMESTAMP(NOW()), NULL, 'new', 'live', ?, ?)",
				PreparedStatement.RETURN_GENERATED_KEYS);
			
			stmt.setString(1, player.getName());
			stmt.setString(2, summary);
			stmt.setString(3, description);
			if(stmt.executeUpdate() == 1) {
				result = stmt.getGeneratedKeys();
				result.next();
				int id = result.getInt(1);
				return new Report(id);
			} else {
				return null;
			}
		} finally {
			close(con, stmt, result);
		}
	}
	
	private void refresh(Report report) throws SQLException {
		Connection con = getConnection();
		PreparedStatement stmt = null;
		ResultSet result = null;
		try {
			stmt = con.prepareStatement("UPDATE reports SET updated = UNIX_TIMESTAMP(NOW()) WHERE id = ?");
			
			stmt.setInt(1, report.getId());
			stmt.executeUpdate();
		} finally {
			close(con, stmt, result);
		}
	}
	
	private boolean changeType(Report report, String oldType, String type) throws SQLException {
		Connection con = getConnection();
		PreparedStatement stmt = null;
		ResultSet result = null;
		try {
			stmt = con.prepareStatement("UPDATE reports "
					+ "SET updated = UNIX_TIMESTAMP(NOW()), type = ? WHERE id = ? AND type = ?");
			
			stmt.setString(1, type);
			stmt.setInt(2, report.getId());
			stmt.setString(3, oldType);
			if(stmt.executeUpdate() == 1) {
				return true;
			}
		} finally {
			close(con, stmt, result);
		}
		return false;
	}
	
	private void addComment(Report report, String comment) throws SQLException {
		Connection con = getConnection();
		PreparedStatement stmt = null;
		ResultSet result = null;
		try {
			stmt = con.prepareStatement("INSERT INTO report_post VALUES(0, ?, NULL, UNIX_TIMESTAMP(NOW()), ?)");
			
			stmt.setInt(1, report.getId());
			stmt.setString(2, comment);
			stmt.executeUpdate();
		} finally {
			close(con, stmt, result);
		}
	}
	
	private void addUpdate(Report report, String type) throws SQLException {
		Connection con = getConnection();
		PreparedStatement stmt = null;
		ResultSet result = null;
		try {
			stmt = con.prepareStatement("INSERT INTO report_update "
					+ "VALUES(0, ?, NULL, UNIX_TIMESTAMP(NOW()), NULL, NULL, ?, NULL)");
			
			stmt.setInt(1, report.getId());
			stmt.setString(2, type);
			stmt.executeUpdate();
		} finally {
			close(con, stmt, result);
		}
	}
	
}
