package rcon.players;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;

import rcon.database.Database;
import rcon.database.DatabaseModule;

public class StatsDatabase extends DatabaseModule {
	
	public StatsDatabase(Database database, String id) {
		super(database, id);
	}
	
	public void updateStats(Player player, boolean disconnect) throws SQLException {
		PlayerInfo info = player.getInfo();
		
		int id = player.getId();
		int kills = info.getKills();
		int deaths = info.getDeaths();
		int score = info.getScore();
		
		long time;
		if(disconnect) {
			time = Calendar.getInstance().getTimeInMillis() / 1000 - player.getCreated();
		} else {
			time = 0;
		}
		
		Connection con = getConnection();
		PreparedStatement stmt = null;
		ResultSet result = null;
		try {
			stmt = con
				.prepareStatement("INSERT INTO stats (id, kills, deaths, score, time) VALUES(?, ?, ?, ?, ?) "
						+ "ON duplicate KEY UPDATE kills = kills + ?, deaths = deaths + ?, score = score + ?, time = time + ?");
			
			int i = 1;
			stmt.setInt(i++, id);
			stmt.setInt(i++, kills);
			stmt.setInt(i++, deaths);
			stmt.setInt(i++, score);
			stmt.setLong(i++, time);
			stmt.setInt(i++, kills);
			stmt.setInt(i++, deaths);
			stmt.setInt(i++, score);
			stmt.setLong(i++, time);
			
			stmt.executeUpdate();
		} finally {
			close(con, stmt, result);
		}
		
	}
	
	public Ranking getRank(Player player) throws SQLException {
		Connection con = getConnection();
		PreparedStatement stmt = null;
		ResultSet result = null;
		try {
			stmt = con.prepareStatement("SELECT COUNT(*)+1 AS rank, (SELECT COUNT(*) FROM stats) AS count "
					+ "FROM stats WHERE score > COALESCE((SELECT score FROM stats WHERE id = ?), 0)");
			
			stmt.setInt(1, player.getId());
			
			result = stmt.executeQuery();
			result.next();
			int rank = result.getInt("rank");
			int count = result.getInt("count");
			return new Ranking(rank, count);
		} finally {
			close(con, stmt, result);
		}
	}
	
}
