package rcon.server;

import rcon.server.Configuration.Variable;

public class ConfigSynchronizer implements Runnable {
	
	private volatile boolean	enabled;
	private GameServer			server;
	
	public ConfigSynchronizer(GameServer server) {
		this.server = server;
		this.enabled = true;
	}
	
	@Override
	public void run() {
		if(!enabled) {
			throw new IllegalStateException("Configuration synchronization is disabled.");
		}
		
		Configuration config = server.getConfiguration();
		for(Variable var : Variable.values()) {
			String currentValue = server.getVariable("vars." + var.getName());
			if(currentValue != null) {
				if(!currentValue.equals(config.get(var))) {
					if(config.isEnforced(var)) {
						boolean ret = server.setVariable("vars." + var.getName(), config.get(var));
						if(!ret) {
							// TODO Log.
						}
					} else {
						config.update(var, currentValue);
					}
				}
			}
		}
	}
	
	public void stop() {
		enabled = false;
	}
	
}
