package rcon.server;

import org.apache.log4j.Logger;

public class HeartbeatChecker implements Runnable {
	
	static Logger				logger	= Logger.getLogger(HeartbeatChecker.class);
	
	private GameServer			server;
	private volatile boolean	enabled;
	
	public HeartbeatChecker(GameServer server) {
		this.server = server;
		this.enabled = true;
	}
	
	@Override
	public void run() {
		if(!enabled) {
			throw new IllegalStateException("Heartbeats are disabled.");
		}
		logger.trace("Sending heartbeat command...");
		
		int version = server.getVersion();
		if(version == -1) {
			logger.warn("Invalid response from hearbeat command.");
		} else {
			logger.trace("Heartbeat response received. ");
		}
	}
	
	public void stop() {
		enabled = false;
	}
	
}
