package rcon.server;

import java.util.ArrayList;
import java.util.HashMap;

import org.apache.log4j.Logger;

import rcon.players.Player;

public class OnlineList {
	
	static Logger					logger	= Logger.getLogger(OnlineList.class);
	
	private HashMap<String, Player>	players;
	private Player					server;
	
	public OnlineList() {
		players = new HashMap<String, Player>();
		server = null;
	}
	
	public synchronized Player getByName(String name) {
		Player player = players.get(name);
		if(player == null && server != null && server.getName().equals(name)) {
			player = server;
		}
		return player;
	}
	
	public synchronized Player ensureGetByName(String name) {
		Player player = players.get(name);
		if(player == null && server != null && server.getName().equals(name)) {
			player = server;
		} else if(player == null) {
			player = new Player(name);
			players.put(name, player);
			logger.debug("Adding missing player to online list - " + name + ".");
			print(Thread.currentThread().getStackTrace());
		}
		return player;
	}
	
	private void print(StackTraceElement[] trace) {
		for(StackTraceElement e : trace) {
			logger.trace(e.toString());
		}
	}
	
	public synchronized ArrayList<Player> getByPartialName(String text) {
		ArrayList<Player> matches = new ArrayList<Player>();
		for(Player p : players.values()) {
			if(p.getFullName().toLowerCase().contains(text.toLowerCase())) {
				matches.add(p);
			}
		}
		return matches;
	}
	
	public synchronized ArrayList<Player> getPlayers() {
		return new ArrayList<Player>(players.values());
	}
	
	protected synchronized void addPlayer(Player player) {
		players.put(player.getName(), player);
		logger.debug("Unconditionally adding player to online list - " + player.toString() + ".");
		print(Thread.currentThread().getStackTrace());
	}
	
	protected synchronized void removePlayer(Player player) {
		players.remove(player.getName());
		logger.debug("Unconditionally removing player from online list - " + player + ".");
		print(Thread.currentThread().getStackTrace());
	}
	
	@Override
	public synchronized String toString() {
		StringBuilder sb = new StringBuilder();
		sb.append("Online player list:\n");
		for(Player p : players.values()) {
			sb.append(p.getFullName());
			sb.append(": ");
			sb.append(p.getEaGuid());
			sb.append(", ");
			sb.append(p.getPbGuid());
			sb.append(", ");
			sb.append(p.getIp());
			sb.append('\n');
		}
		return sb.toString();
	}
	
	public synchronized ArrayList<Player> getAdmins() {
		ArrayList<Player> admins = new ArrayList<Player>();
		for(Player p : players.values()) {
			if(p.isAdmin()) {
				admins.add(p);
			}
		}
		return admins;
	}
	
	public synchronized int size() {
		return players.size();
	}
	
	public synchronized void setServerPlayer(Player player) {
		server = player;
		System.out.println("Set server player to " + player.getName() + " " + player.getAdmin().getId() + ".");
	}
	
}
