package rcon.server;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;

import org.apache.log4j.Logger;

import rcon.ingame.ServerMessage;
import rcon.ingame.ServerMessages;

public class ServerMessenger implements Runnable {
	
	static Logger				logger	= Logger.getLogger(ServerMessenger.class);
	
	private ServerMessages		messages;
	private GameServer			server;
	private volatile boolean	enabled;
	
	public ServerMessenger(GameServer server, ServerMessages messages) {
		this.messages = messages;
		this.server = server;
		this.enabled = true;
	}
	
	@Override
	public void run() {
		if(!enabled) {
			throw new IllegalStateException("Heartbeats are disabled.");
		}
		
		ServerMessage m = messages.next();
		if(m != null) {
			logger.trace("Sending server message \"" + m.getMessage() + "\".");
			String message = m.getMessage();
			BufferedReader r = new BufferedReader(new StringReader(message));
			try {
				String line;
				while((line = r.readLine()) != null) {
					server.say(line);
				}
			} catch(IOException e) {}
		}
		
	}
	
	public void stop() {
		enabled = false;
	}
	
}
