/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.LudumDareGame;
import game.LudumDareGameState;
import game.engine.loader.EntityLoader;
import game.world.GameWorld;
import org.newdawn.slick.Color;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.state.BasicGameState;
import org.newdawn.slick.state.StateBasedGame;
import org.newdawn.slick.state.transition.FadeInTransition;
import org.newdawn.slick.state.transition.FadeOutTransition;

public class LudumDareGameplayState
extends BasicGameState {
    private GameWorld world;
    private EntityLoader loader;
    private float postGameTime;

    public void init(GameContainer container, StateBasedGame game) throws SlickException {
        this.loader = new EntityLoader("assets/xml");
        this.world = new GameWorld(this.loader, LudumDareGame.config, container);
    }

    public void render(GameContainer container, StateBasedGame game, Graphics g) throws SlickException {
        this.world.render(g, container);
    }

    public void update(GameContainer container, StateBasedGame game, int dt) throws SlickException {
        if (this.world.isVictorious() || this.world.isDefeated()) {
            this.postGameTime += (float)dt / 1000.0f;
            if (this.postGameTime >= 5.0f) {
                LudumDareGameState nextState = this.world.isVictorious() ? LudumDareGameState.victory : LudumDareGameState.defeat;
                game.enterState(nextState.ordinal(), new FadeOutTransition(Color.black, 1000), new FadeInTransition(Color.black, 1000));
            }
        }
        this.world.update(dt, container);
    }

    public int getID() {
        return LudumDareGameState.game.ordinal();
    }

    public void leave(GameContainer container, StateBasedGame game) throws SlickException {
        super.leave(container, game);
        Image endScreen = new Image(container.getWidth(), container.getHeight());
        Graphics g = endScreen.getGraphics();
        this.render(container, game, g);
        g.flush();
        ((LudumDareGame)game).setEndScreen(endScreen);
    }

    public void enter(GameContainer container, StateBasedGame game) throws SlickException {
        super.enter(container, game);
        this.postGameTime = 0.0f;
    }
}

