/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.LudumDareGameState;
import org.newdawn.slick.Color;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.state.BasicGameState;
import org.newdawn.slick.state.StateBasedGame;
import org.newdawn.slick.state.transition.FadeInTransition;
import org.newdawn.slick.state.transition.FadeOutTransition;
import org.newdawn.slick.util.ResourceLoader;

public class LudumDareVictoryState
extends BasicGameState {
    private static final String IMAGE_FILE = "assets/graphics/win_screen.png";
    private Image image;

    public void init(GameContainer container, StateBasedGame game) throws SlickException {
        this.image = new Image(ResourceLoader.getResourceAsStream(IMAGE_FILE), IMAGE_FILE, false, 1);
    }

    public void update(GameContainer container, StateBasedGame game, int delta) throws SlickException {
        if (LudumDareGameState.isAcceptKeyPressed(container.getInput())) {
            game.enterState(LudumDareGameState.title.ordinal(), new FadeOutTransition(Color.black, 1000), new FadeInTransition(Color.black, 1000));
        }
    }

    public void render(GameContainer container, StateBasedGame game, Graphics g) throws SlickException {
        this.image.draw(0.0f, 0.0f, (float)container.getWidth(), container.getHeight());
    }

    public int getID() {
        return LudumDareGameState.victory.ordinal();
    }

    public void enter(GameContainer container, StateBasedGame game) throws SlickException {
        super.enter(container, game);
        container.getInput().clearKeyPressedRecord();
        container.getInput().clearMousePressedRecord();
        container.getInput().clearControlPressedRecord();
    }
}

