/*
 * Decompiled with CFR 0.152.
 */
package game.engine;

import game.engine.BoundingBox;
import game.engine.loader.AssetStore;
import game.engine.loader.EntityDescriptor;
import game.engine.loader.PropertyStore;
import game.engine.util.MathUtil;
import org.newdawn.slick.Animation;
import org.newdawn.slick.Color;
import org.newdawn.slick.Font;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.geom.Vector2f;
import org.newdawn.slick.openal.Audio;
import org.newdawn.slick.particles.ConfigurableEmitter;

public abstract class BaseEntity {
    protected static final float DEBUG_TEXT_SCALE = 2.0f;
    private static final int RENDER_BIN_DEFAULT = 0;
    protected final String name;
    private Vector2f pos;
    private float rotation;
    private float scale;
    private BoundingBox bounds;
    private String currentAnimationState;
    private boolean destroyed;
    protected final AssetStore<Animation> animations;
    protected final AssetStore<BoundingBox> boundingBoxes;
    protected final AssetStore<ConfigurableEmitter> emitters;
    protected final AssetStore<Audio> sounds;
    protected final AssetStore<Font> fonts;
    protected final PropertyStore properties;
    private final int renderBin;
    private boolean transformedRendering;
    private boolean customRendering;

    public BaseEntity(EntityDescriptor descriptor) {
        this.name = descriptor.name;
        this.pos = new Vector2f(0.0f, 0.0f);
        this.rotation = 0.0f;
        this.scale = descriptor.scale;
        BoundingBox defaultBoundingBox = descriptor.boundingBoxes.get("bounds");
        BoundingBox boundingBox = this.bounds = defaultBoundingBox == null ? null : defaultBoundingBox.clone();
        if (this.bounds != null) {
            this.bounds.scale(this.scale);
        }
        this.currentAnimationState = "default";
        this.destroyed = false;
        this.animations = descriptor.animations;
        this.boundingBoxes = descriptor.boundingBoxes;
        this.emitters = descriptor.particleEmitters;
        this.sounds = descriptor.sounds;
        this.fonts = descriptor.fonts;
        this.properties = descriptor.properties;
        this.renderBin = descriptor.properties.getInt("renderbin", 0);
        this.transformedRendering = true;
        this.customRendering = false;
    }

    public Vector2f getPos() {
        return this.pos;
    }

    public void setPos(float x, float y) {
        this.pos.x = x;
        this.pos.y = y;
    }

    public void setPos(Vector2f worldPos) {
        this.setPos(worldPos.x, worldPos.y);
    }

    public void translate(float x, float y) {
        this.pos.x += x;
        this.pos.y += y;
    }

    public void translate(Vector2f translation) {
        this.pos.add(translation);
    }

    public float getScale() {
        return this.scale;
    }

    public void setScale(float scale) {
        this.bounds.scale(scale / this.scale);
        this.scale = scale;
    }

    public float getRotation() {
        return this.rotation;
    }

    public void setRotation(float rotation) {
        this.rotation = MathUtil.wrap(rotation, 0.0f, 360.0f);
    }

    public void rotate(float rotation) {
        this.rotation = MathUtil.wrap(this.rotation + rotation, 0.0f, 360.0f);
    }

    protected void setAnimationState(String state) {
        if (!this.animations.contains(state)) {
            throw new RuntimeException("Cannot switch to unknown animation state \"" + state + "\".");
        }
        if (this.customRendering) {
            throw new RuntimeException("Changing the animation state when custom rendering is enabled makes no sense.");
        }
        this.currentAnimationState = state;
    }

    protected void destroy() {
        if (this.destroyed) {
            throw new RuntimeException("An entity should not be destroyed twice.");
        }
        this.destroyed = true;
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public int compareRenderOrder(BaseEntity other) {
        return Integer.valueOf(this.getRenderBin()).compareTo(other.getRenderBin());
    }

    public BoundingBox getBounds() {
        return this.bounds;
    }

    public Vector2f getCenter() {
        Vector2f ret = new Vector2f();
        this.getCenter(ret);
        return ret;
    }

    public void getCenter(Vector2f centerOut) {
        centerOut.x = this.bounds.getCenterX(this.getPos());
        centerOut.y = this.bounds.getCenterY(this.getPos());
    }

    protected void playAudio(String name, float volume) {
        if (!this.sounds.contains(name)) {
            throw new RuntimeException("Invalid sound requested \"" + name + "\".");
        }
        this.sounds.get(name).playAsSoundEffect(1.0f, volume, false);
    }

    protected String getProperty(String key, String def) {
        String value = (String)this.properties.get(key);
        if (value == null) {
            value = def;
        }
        return value;
    }

    protected void internalDebugRender(Graphics g) {
        BoundingBox bounds = this.getBounds();
        if (bounds != null) {
            g.setColor(new Color(0.0f, 0.0f, 1.0f, 0.3f));
            g.fillRect(bounds.getMinX(this.pos), bounds.getMinY(this.pos), bounds.getWidth(), bounds.getHeight());
            g.setColor(Color.blue);
            g.drawRect(bounds.getMinX(this.pos), bounds.getMinY(this.pos), bounds.getWidth(), bounds.getHeight());
        }
        if (bounds != null) {
            g.pushTransform();
            g.translate(bounds.getMinX(this.pos), bounds.getMinY(this.pos));
            g.scale(2.0f, 2.0f);
            g.setColor(Color.red);
            StringBuilder sb = this.internalGetDebugText();
            g.drawString(sb.toString(), 3.0f, 3.0f);
            g.popTransform();
        }
    }

    private StringBuilder internalGetDebugText() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name);
        sb.append('\n');
        sb.append(String.format("P: (%.1f,%.1f)\n", Float.valueOf(this.getPos().x), Float.valueOf(this.getPos().y)));
        this.getDebugText(sb);
        return sb;
    }

    protected void getDebugText(StringBuilder sb) {
    }

    protected boolean internalPreRender(Graphics g) {
        if (!this.customRendering && this.animations.isEmpty()) {
            return false;
        }
        if (this.transformedRendering) {
            this.applyTransform(g);
        }
        return true;
    }

    protected void internalRender(Graphics g) {
        if (!this.customRendering && this.animations.contains(this.currentAnimationState)) {
            Animation animation = this.animations.get(this.currentAnimationState);
            g.drawAnimation(animation, 0.0f, 0.0f);
        }
    }

    protected void internalPostRender(Graphics g) {
        if (this.transformedRendering) {
            this.applyInverseTransform(g);
        }
    }

    protected void applyTransform(Graphics g) {
        g.translate(Math.round(this.pos.x), Math.round(this.pos.y));
        float cx = 0.0f;
        float cy = 0.0f;
        BoundingBox bb = this.getBounds();
        if (bb != null) {
            cx = bb.getCenterX(0.0f, 0.0f);
            cy = bb.getCenterY(0.0f, 0.0f);
        }
        g.rotate(Math.round(cx), Math.round(cy), this.rotation);
        g.scale(this.scale, this.scale);
    }

    protected void applyInverseTransform(Graphics g) {
        float cx = 0.0f;
        float cy = 0.0f;
        BoundingBox bb = this.getBounds();
        if (bb != null) {
            cx = bb.getCenterX(0.0f, 0.0f);
            cy = bb.getCenterY(0.0f, 0.0f);
        }
        g.scale(1.0f / this.scale, 1.0f / this.scale);
        g.rotate(Math.round(cx), Math.round(cy), -this.rotation);
        g.translate(-Math.round(this.pos.x), -Math.round(this.pos.y));
    }

    protected void disableTransformedRendering() {
        this.transformedRendering = false;
    }

    protected void enableCustomRendering() {
        this.customRendering = true;
    }

    public String getName() {
        return this.name;
    }

    protected int getRenderBin() {
        return this.renderBin;
    }
}

