/*
 * Decompiled with CFR 0.152.
 */
package game.engine;

import game.engine.BoundingBox;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.geom.Vector2f;

public class GameCamera {
    private BoundingBox screenBounds = null;
    private Vector2f screenSize = new Vector2f(0.0f, 0.0f);
    protected float scale = 1.0f;
    protected Vector2f screenPos = new Vector2f(0.0f, 0.0f);

    public void setScale(float scale) {
        this.scale = scale;
        this.updateBounds();
    }

    public float getScale() {
        return this.scale;
    }

    public void init(int screenWidth, int screenHeight) {
        this.screenPos.set(0.0f, 0.0f);
        this.screenSize.set(screenWidth, screenHeight);
        this.updateBounds();
    }

    public void update(int dt) {
    }

    protected void updateBounds() {
        this.screenBounds = new BoundingBox(-this.screenSize.x / (2.0f * this.scale), -this.screenSize.y / (2.0f * this.scale), this.screenSize.x / this.scale, this.screenSize.y / this.scale);
    }

    public BoundingBox getScreenBounds() {
        if (this.screenBounds == null) {
            return new BoundingBox(0.0f, 0.0f, 0.0f, 0.0f);
        }
        return this.screenBounds;
    }

    public Vector2f getScreenPos() {
        return this.screenPos;
    }

    public void applyTransform(Graphics g, GameContainer container) {
        g.translate((float)container.getWidth() / 2.0f, (float)container.getHeight() / 2.0f);
        g.scale(this.scale, this.scale);
        g.translate(-Math.round(this.screenPos.x), -Math.round(this.screenPos.y));
    }

    public void applyInverseTransform(Graphics g, GameContainer container) {
        g.translate(Math.round(this.screenPos.x), Math.round(this.screenPos.y));
        g.scale(1.0f / this.scale, 1.0f / this.scale);
        g.translate((float)(-container.getWidth()) / 2.0f, (float)(-container.getHeight()) / 2.0f);
    }

    public Vector2f screenToWorld(float x, float y) {
        float sx = this.getScreenBounds().getMinX(this.getScreenPos());
        float sy = this.getScreenBounds().getMinY(this.getScreenPos());
        return new Vector2f(sx + x / this.scale, sy + y / this.scale);
    }

    protected Vector2f getScreenSize() {
        return this.screenSize;
    }
}

