/*
 * Decompiled with CFR 0.152.
 */
package game.engine.spatial;

import game.engine.spatial.BaseShape;
import game.engine.util.MathUtil;
import org.newdawn.slick.Color;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.geom.Vector2f;

public class CircleShape
extends BaseShape {
    private final float radius;
    private final Vector2f offset;

    public CircleShape(Vector2f offset, float radius) {
        this.offset = offset;
        this.radius = radius;
    }

    public CircleShape(float radius) {
        this.offset = new Vector2f();
        this.radius = radius;
    }

    public float rayTest(Vector2f at, Vector2f from, Vector2f to) {
        float lToX = to.x - at.x - this.offset.x;
        float lFromX = from.x - at.x - this.offset.x;
        float lDeltaX = lToX - lFromX;
        float lToY = to.y - at.y - this.offset.y;
        float lFromY = from.y - at.y - this.offset.y;
        float lDeltaY = lToY - lFromY;
        float b = 2.0f * (lDeltaX * lFromX + lDeltaY * lFromY);
        float a = lDeltaX * lDeltaX + lDeltaY * lDeltaY;
        float c = lFromX * lFromX + lFromY * lFromY - this.radius * this.radius;
        float delta = b * b - 4.0f * a * c;
        if (delta < 0.0f) {
            return Float.NaN;
        }
        if (delta == 0.0f) {
            float u = -b / (2.0f * a);
            if (u >= 0.0f && u <= 1.0f) {
                return u;
            }
            return Float.NaN;
        }
        float squareRootDelta = MathUtil.sqrtf(delta);
        float u = (-b - squareRootDelta) / (2.0f * a);
        if (u >= 0.0f && u <= 1.0f) {
            return u;
        }
        return Float.NaN;
    }

    public boolean contains(Vector2f at, BaseShape shape, Vector2f at2) {
        if (shape instanceof CircleShape) {
            CircleShape o = (CircleShape)shape;
            Vector2f d = at.copy().add(this.offset).sub(at2).sub(o.offset);
            return d.lengthSquared() < (this.radius + o.radius) * (this.radius + o.radius);
        }
        throw new RuntimeException("Unsupported shape type.");
    }

    public void debugRender(Graphics g, Vector2f p) {
        g.setColor(Color.yellow);
        g.drawOval(p.x + this.offset.x - this.radius, p.y + this.offset.y - this.radius, 2.0f * this.radius, 2.0f * this.radius);
    }
}

