/*
 * Decompiled with CFR 0.152.
 */
package game.engine.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RandomSelector<T>
implements Iterator<T> {
    private float totalChance;
    private ArrayList<Entry<T>> entries;
    private Random random;

    public RandomSelector(Random random) {
        this.random = random;
        this.totalChance = 0.0f;
        this.entries = new ArrayList();
    }

    public void add(T object, float chance) {
        this.totalChance += chance;
        this.entries.add(new Entry<T>(object, chance));
    }

    @Override
    public T next() {
        float rand = this.random.nextFloat() * this.totalChance;
        float sum = 0.0f;
        Object entityName = this.entries.get((int)(this.entries.size() - 1)).object;
        for (Entry<T> e : this.entries) {
            if (!(rand < (sum += e.chance))) continue;
            entityName = e.object;
            break;
        }
        return entityName;
    }

    @Override
    public boolean hasNext() {
        return true;
    }

    @Override
    public void remove() {
        throw new RuntimeException("Operation not supported.");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Entry<T> {
        public final T object;
        public final float chance;

        public Entry(T object, float chance) {
            this.object = object;
            this.chance = chance;
        }
    }
}

