/*
 * Decompiled with CFR 0.152.
 */
package game.entities;

import game.engine.BoundingBox;
import game.engine.loader.EntityDescriptor;
import game.engine.spatial.SpatialObject;
import game.engine.util.RandomSelector;
import game.entities.Projectile;
import game.entities.ScrapPart;
import game.entities.SpaceEntity;
import game.util.BulletHitHandler;
import game.util.ScrapPartSocket;
import game.util.SocketLayers;
import game.util.WeaponPlatform;
import game.world.GameWorld;
import org.newdawn.slick.Color;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.geom.Vector2f;

public abstract class BaseShip
extends SpaceEntity
implements BulletHitHandler {
    protected SocketLayers sockets = new SocketLayers();
    private float[] scrapAttachRadius;
    private float[] scrapNormalForceRadius;
    private float[] scrapWeakForceRadius;
    private float[] scrapStrongForceRadius;
    private float health = this.maxHealth = this.properties.getFloat("max_health", 100.0f);
    private float maxHealth;
    private float socketRotationSpeed = this.properties.getFloat("socket_rotation_speed", 0.0f);
    protected BaseShip enemy = null;

    public BaseShip(EntityDescriptor descriptor) {
        super(descriptor);
        this.scrapNormalForceRadius = this.properties.getFloatArray("scrap_normal_force_radius", 512.0f, 640.0f, 768.0f, 896.0f);
        this.scrapWeakForceRadius = this.properties.getFloatArray("scrap_weak_force_radius", 1024.0f, 1280.0f, 1536.0f, 1792.0f);
        this.scrapStrongForceRadius = this.properties.getFloatArray("scrap_strong_force_radius", 256.0f, 384.0f, 512.0f, 640.0f);
        this.scrapAttachRadius = this.properties.getFloatArray("scrap_attach_radius", 128.0f, 256.0f, 384.0f, 512.0f);
    }

    public void init(GameWorld world) {
        super.init(world);
        int socketLayers = this.properties.getInt("socket_layers", 4);
        int filledSocketLayers = this.properties.getInt("filled_socket_layers", 0);
        String[] socketParts = this.properties.getArray("filled_socket_parts", new String[0]);
        this.sockets.construct(world, this, socketLayers);
        for (int layer = 0; layer < filledSocketLayers; ++layer) {
            RandomSelector<String> creator = new RandomSelector<String>(world.getRandom());
            float[] socketPartChances = this.properties.getFloatArray("filled_socket_chances" + (layer + 1), new float[socketParts.length]);
            for (int i = 0; i < socketParts.length; ++i) {
                creator.add(socketParts[i], socketPartChances[i]);
            }
            this.sockets.populateLayer(world, layer, creator);
        }
    }

    public void update(int dt, GameWorld world, GameContainer container) {
        super.update(dt, world, container);
        this.sockets.rotate(this.socketRotationSpeed * (float)dt / 1000.0f);
        int outerLayer = Math.min(this.sockets.getNormalPopulatedLayer(), this.scrapAttachRadius.length - 1);
        float normalRadius = this.scrapNormalForceRadius[outerLayer];
        float weakRadius = this.scrapWeakForceRadius[outerLayer];
        float strongRadius = this.scrapStrongForceRadius[outerLayer];
        float attachRadius = this.scrapAttachRadius[outerLayer];
        float maxRadius = Math.max(Math.max(normalRadius, weakRadius), Math.max(strongRadius, attachRadius));
        Vector2f temp = new Vector2f();
        this.getCenter(temp);
        for (SpatialObject o : world.getSpatialManager().sphereQuery(temp, maxRadius)) {
            ScrapPart part;
            if (!(o.userData instanceof ScrapPart) || (part = (ScrapPart)o.userData).isSocketed() || !part.isAttachable()) continue;
            temp.sub(o.position);
            float dist = temp.length();
            if (dist <= attachRadius) {
                ScrapPartSocket socket = this.sockets.getInnermostEmpty();
                if (socket == null) continue;
                part.setSocket(socket);
                part.resetHealth();
                this.playAudio("attach", 1.0f);
                continue;
            }
            float acceleration = 0.0f;
            if (dist < strongRadius) {
                acceleration = 1200.0f;
            } else if (dist < normalRadius) {
                acceleration = 400.0f;
            } else if (dist < weakRadius) {
                acceleration = 100.0f;
            }
            temp.normalise().scale(acceleration * (float)dt / 1000.0f);
            part.addVelocity(temp);
        }
    }

    public void debugRender(Graphics g, GameWorld world, GameContainer container) {
        super.debugRender(g, world, container);
        BoundingBox bb = this.getBounds();
        Vector2f p = this.getPos();
        if (this.getBounds() != null) {
            float x = bb.getCenterX(p);
            float y = bb.getCenterY(p);
            int outerLayer = Math.min(this.sockets.getNormalPopulatedLayer(), this.scrapAttachRadius.length - 1);
            float normalRadius = this.scrapNormalForceRadius[outerLayer];
            float weakRadius = this.scrapWeakForceRadius[outerLayer];
            float strongRadius = this.scrapStrongForceRadius[outerLayer];
            float attachRadius = this.scrapAttachRadius[outerLayer];
            float r = weakRadius;
            g.setColor(Color.green);
            g.drawOval(x - r, y - r, 2.0f * r, 2.0f * r);
            r = normalRadius;
            g.setColor(Color.yellow);
            g.drawOval(x - r, y - r, 2.0f * r, 2.0f * r);
            r = strongRadius;
            g.setColor(Color.orange);
            g.drawOval(x - r, y - r, 2.0f * r, 2.0f * r);
            r = attachRadius;
            g.setColor(Color.red);
            g.drawOval(x - r, y - r, 2.0f * r, 2.0f * r);
        }
        int outerLayer = Math.min(this.sockets.getNormalPopulatedLayer(), this.scrapAttachRadius.length - 1);
        float normalRadius = this.scrapNormalForceRadius[outerLayer];
        float weakRadius = this.scrapWeakForceRadius[outerLayer];
        float strongRadius = this.scrapStrongForceRadius[outerLayer];
        float attachRadius = this.scrapAttachRadius[outerLayer];
        float maxRadius = Math.max(Math.max(normalRadius, weakRadius), Math.max(strongRadius, attachRadius));
        Vector2f temp = new Vector2f();
        this.getCenter(temp);
        for (SpatialObject o : world.getSpatialManager().sphereQuery(temp, maxRadius)) {
            ScrapPart part;
            if (!(o.userData instanceof ScrapPart) || (part = (ScrapPart)o.userData).isSocketed() || !part.isAttachable()) continue;
            Vector2f thisCenter = temp;
            Vector2f thatCenter = part.getCenter();
            g.setColor(Color.green);
            g.drawLine(thisCenter.x, thisCenter.y, thatCenter.x, thatCenter.y);
        }
    }

    public void registerWeaponPlatform(WeaponPlatform platform) {
    }

    public void onHit(Projectile proj) {
        if (this.health > 0.0f) {
            this.health = Math.max(0.0f, this.health - proj.getPower());
            if (this.health <= 0.0f) {
                for (ScrapPartSocket socket : this.sockets) {
                    if (!socket.isOccupied()) continue;
                    socket.getSocketedPart().eject();
                }
            }
        }
    }

    public boolean isDead() {
        return this.health <= 0.0f;
    }

    public void setEnemy(BaseShip enemy) {
        this.enemy = enemy;
    }

    protected void getTargetVector(Vector2f out) {
        this.enemy.getCenter(out);
        BoundingBox bb = this.getBounds();
        out.x -= bb.getCenterX(this.getPos());
        out.y -= bb.getCenterY(this.getPos());
    }
}

