/*
 * Decompiled with CFR 0.152.
 */
package game.entities;

import game.engine.BoundingBox;
import game.engine.loader.EntityDescriptor;
import game.engine.util.MathUtil;
import game.entities.BaseShip;
import game.util.FireTarget;
import game.util.FireTrigger;
import game.util.WeaponPlatform;
import game.world.GameWorld;
import org.newdawn.slick.Color;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.geom.Vector2f;

public class BossShip
extends BaseShip {
    private static final float TARGET_FORCE_MAX = 100.0f;
    private static final float TARGET_DISTANCE_MIN = 800.0f;
    private static final float TARGET_DISTANCE_MAX = 1400.0f;
    private static final float BREAK_FORCE = 300.0f;
    private static final float SPEED_MIN = 10.0f;
    private static final float ACCELERATION_MAX = 250.0f;
    private static final float VELOCITY_MAX = 1600.0f;
    private Vector2f acceleration = new Vector2f();
    private EngineState engine = EngineState.idle;

    public BossShip(EntityDescriptor descriptor) {
        super(descriptor);
    }

    public void init(GameWorld world) {
        super.init(world);
    }

    public void update(int dt, GameWorld world, GameContainer container) {
        super.update(dt, world, container);
        Vector2f forward = new Vector2f();
        this.getForward(forward);
        Vector2f targetDirection = new Vector2f();
        this.getTargetVector(targetDirection);
        float targetDistance = targetDirection.length();
        targetDirection.normalise();
        Vector2f deltaVelocity = this.velocity.copy().sub(this.enemy.getVelocity());
        this.acceleration.set(0.0f, 0.0f);
        switch (this.engine) {
            case idle: {
                if (this.velocity.lengthSquared() > 10.0f) {
                    this.engine = EngineState.stopping;
                }
                if (!(targetDistance > 1400.0f) && !(targetDistance < 800.0f) && !(deltaVelocity.lengthSquared() > 25.0f)) break;
                this.engine = EngineState.chasing;
                break;
            }
            case stopping: {
                if (!(this.velocity.lengthSquared() < 10.0f)) break;
                this.engine = EngineState.idle;
                break;
            }
            case chasing: {
                if (!(this.enemy.getVelocity().lengthSquared() < 400.0f) || !(targetDistance < 1400.0f) || !(targetDistance > 800.0f)) break;
                this.engine = EngineState.stopping;
                break;
            }
        }
        this.engine = EngineState.idle;
        switch (this.engine) {
            case idle: {
                this.acceleration.x -= this.velocity.x * 0.7f;
                this.acceleration.y -= this.velocity.y * 0.7f;
                break;
            }
            case stopping: {
                Vector2f dir = this.velocity.copy().normalise();
                this.acceleration.x -= MathUtil.absoluteMin(dir.x * 300.0f, this.velocity.x / (float)dt * 1000.0f);
                this.acceleration.y -= MathUtil.absoluteMin(dir.y * 300.0f, this.velocity.y / (float)dt * 1000.0f);
                break;
            }
            case chasing: {
                float dv = deltaVelocity.length();
                if (dv > 5.0f) {
                    deltaVelocity.normalise();
                    this.acceleration.x -= deltaVelocity.x * 100.0f * MathUtil.clamp(dv / 50.0f, 0.0f, 1.0f);
                    this.acceleration.y -= deltaVelocity.y * 100.0f * MathUtil.clamp(dv / 50.0f, 0.0f, 1.0f);
                }
                if (targetDistance > 1400.0f) {
                    this.acceleration.x += targetDirection.x * 100.0f;
                    this.acceleration.y += targetDirection.y * 100.0f;
                    break;
                }
                if (!(targetDistance < 800.0f)) break;
                this.acceleration.x -= targetDirection.x * 100.0f;
                this.acceleration.y -= targetDirection.y * 100.0f;
                break;
            }
        }
        if (this.acceleration.lengthSquared() > 62500.0f) {
            this.acceleration.scale(250.0f / this.acceleration.length());
        }
        this.velocity.x += this.acceleration.x * (float)dt / 1000.0f;
        this.velocity.y += this.acceleration.y * (float)dt / 1000.0f;
        if (this.velocity.lengthSquared() > 2560000.0f) {
            this.velocity.scale(1600.0f / this.velocity.length());
        }
    }

    public void debugRender(Graphics g, GameWorld world, GameContainer container) {
        super.debugRender(g, world, container);
        BoundingBox bounds = this.getBounds();
        Vector2f pos = this.getPos();
        if (bounds != null) {
            float cx = bounds.getCenterX(pos);
            float cy = bounds.getCenterY(pos);
            Vector2f forward = new Vector2f();
            this.getForward(forward);
            forward.scale(20.0f);
            Vector2f targetDirection = new Vector2f();
            this.getTargetVector(targetDirection);
            float dist = targetDirection.length();
            targetDirection.normalise();
            targetDirection.scale(20.0f);
            g.setColor(Color.green);
            g.drawLine(cx, cy, cx + targetDirection.x, cy + targetDirection.y);
            g.setColor(Color.green);
            g.drawLine(cx, cy, cx + this.acceleration.x, cy + this.acceleration.y);
        }
    }

    private void getForward(Vector2f forward) {
        forward.set(0.0f, -1.0f);
        forward.add(this.getRotation());
    }

    protected void getDebugText(StringBuilder sb) {
        super.getDebugText(sb);
        sb.append(String.format("A: %.1f\n", Float.valueOf(this.acceleration.length())));
        sb.append("S: " + this.engine.toString() + "\n");
    }

    public void registerWeaponPlatform(WeaponPlatform platform) {
        super.registerWeaponPlatform(platform);
        platform.setFireTarget(new FireTarget(){

            public boolean getFireTargetPosition(Vector2f positionOut) {
                BossShip.this.enemy.getCenter(positionOut);
                return true;
            }
        });
        platform.setFireTrigger(new FireTrigger(){

            public boolean shouldFireAtWill() {
                return true;
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum EngineState {
        idle,
        stopping,
        chasing,
        evading;

    }
}

