/*
 * Decompiled with CFR 0.152.
 */
package game.entities;

import game.engine.loader.EntityDescriptor;
import game.entities.Entity;
import game.world.GameWorld;
import org.newdawn.slick.Animation;
import org.newdawn.slick.Color;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;

public class Exclamation
extends Entity {
    private float ttl;
    private float ttl0;
    private boolean fadeout;

    public Exclamation(EntityDescriptor descriptor) {
        super(descriptor);
        this.ttl0 = this.ttl = this.properties.getFloat("time_to_live", 0.25f);
        this.fadeout = this.properties.contains("fadeout");
        this.enableCustomRendering();
    }

    public void update(int dt, GameWorld world, GameContainer container) {
        super.update(dt, world, container);
        this.ttl -= (float)dt / 1000.0f;
        if (this.ttl <= 0.0f) {
            world.getEntities().remove(this);
        }
    }

    public void render(Graphics g, GameWorld world, GameContainer container) {
        Animation animation = (Animation)this.animations.get("default");
        float alpha = 1.0f;
        if (this.fadeout) {
            alpha = 1.0f - (this.ttl0 - this.ttl) / this.ttl0;
        }
        g.drawAnimation(animation, 0.0f, 0.0f, new Color(1.0f, 1.0f, 1.0f, alpha));
    }
}

