/*
 * Decompiled with CFR 0.152.
 */
package game.entities;

import game.engine.loader.EntityDescriptor;
import game.engine.spatial.SpatialQueryManager;
import game.engine.util.MathUtil;
import game.entities.BaseShip;
import game.entities.Exclamation;
import game.entities.Projectile;
import game.util.FireTarget;
import game.util.FireTrigger;
import game.util.WeaponPlatform;
import game.world.GameWorld;
import java.util.List;
import org.newdawn.slick.Color;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.geom.Vector2f;
import org.newdawn.slick.particles.ConfigurableEmitter;
import org.newdawn.slick.particles.ParticleSystem;

public class PlayerShip
extends BaseShip {
    static final float MAXIMUM_BOSS_DISTANCE_SQUARED = 2400.0f;
    private Vector2f shipFront = new Vector2f(0.0f, -1.0f);
    private float turnSpeed = 0.1f;
    float cooldown = 0.0f;
    private ConfigurableEmitter[] engineEmitters = new ConfigurableEmitter[3];
    private ParticleSystem particles;
    private boolean isFiring;
    private final Vector2f targetPosition;
    private float dragFactor;
    private float acceleration;
    private float accelerationDelta;

    public PlayerShip(EntityDescriptor descriptor) {
        super(descriptor);
        this.engineEmitters[0] = descriptor.particleEmitters.get("engine1").duplicate();
        this.engineEmitters[1] = descriptor.particleEmitters.get("engine2").duplicate();
        this.engineEmitters[2] = descriptor.particleEmitters.get("engine3").duplicate();
        this.particles = new ParticleSystem("assets/graphics/placeholder_particle.tga", 300);
        this.particles.addEmitter(this.engineEmitters[0]);
        this.particles.addEmitter(this.engineEmitters[1]);
        this.particles.addEmitter(this.engineEmitters[2]);
        this.disableTransformedRendering();
        this.dragFactor = this.properties.getFloat("drag_factor", 5.0f);
        this.acceleration = this.properties.getFloat("acceleration", 1400.0f);
        this.accelerationDelta = this.properties.getFloat("acceleration_delta", -12.0f);
        this.isFiring = false;
        this.targetPosition = new Vector2f();
    }

    public void update(int dt, GameWorld world, GameContainer container) {
        super.update(dt, world, container);
        this.velocity.x -= this.dragFactor * (float)dt / 1000.0f * this.velocity.x;
        this.velocity.y -= this.dragFactor * (float)dt / 1000.0f * this.velocity.y;
        Vector2f targetDirection = new Vector2f();
        this.getTargetVector(targetDirection);
        float targetDistance = targetDirection.length();
        float targetDistanceSurface = targetDistance - (float)this.sockets.getPopulatedRadius() - (float)this.enemy.sockets.getPopulatedRadius();
        if (targetDistanceSurface < 0.0f) {
            Vector2f tangent = targetDirection.getPerpendicular();
            tangent = tangent.normalise();
            float tangentSpeed = tangent.dot(this.velocity) * 0.005f * (float)dt;
            targetDirection = targetDirection.normalise();
            targetDirection = targetDirection.scale((float)dt * targetDistanceSurface * 0.2f);
            this.velocity.add(targetDirection);
            this.velocity.add(tangent.scale(tangentSpeed));
        } else if (targetDistance < 2400.0f) {
            float acc = this.acceleration + this.sockets.getOccupiedCount() * this.accelerationDelta;
            if (container.getInput().isKeyDown(17)) {
                this.velocity.y -= acc * (float)dt / 1000.0f;
            }
            if (container.getInput().isKeyDown(31)) {
                this.velocity.y += acc * (float)dt / 1000.0f;
            }
            if (container.getInput().isKeyDown(30)) {
                this.velocity.x -= acc * (float)dt / 1000.0f;
            }
            if (container.getInput().isKeyDown(32)) {
                this.velocity.x += acc * (float)dt / 1000.0f;
            }
        } else {
            targetDirection = targetDirection.normalise();
            targetDirection.scale(dt);
            this.velocity = targetDirection;
        }
        int mouseX = container.getInput().getMouseX();
        int mouseY = container.getInput().getMouseY();
        Vector2f mouseVec = world.getCamera().screenToWorld(mouseX, mouseY);
        if (container.getInput().isMouseButtonDown(0)) {
            this.isFiring = true;
            this.targetPosition.set(mouseVec);
        } else {
            this.isFiring = false;
        }
        Vector2f centerPos = new Vector2f();
        this.getCenter(centerPos);
        mouseVec = mouseVec.sub(centerPos);
        float angle = (float)(mouseVec.getTheta() - this.shipFront.getTheta());
        if (angle > 180.0f) {
            angle -= 360.0f;
        } else if (angle < -180.0f) {
            angle += 360.0f;
        }
        angle = MathUtil.clamp(angle, -this.turnSpeed * (float)dt, this.turnSpeed * (float)dt);
        this.rotate(angle);
        angle = (float)(Math.PI * (double)angle / 180.0);
        this.shipFront = new Vector2f((float)((double)this.shipFront.x * Math.cos(angle) - (double)this.shipFront.y * Math.sin(angle)), (float)((double)this.shipFront.x * Math.sin(angle) + (double)this.shipFront.y * Math.cos(angle)));
        this.cooldown -= (float)dt;
        if (container.getInput().isMouseButtonDown(0) && this.cooldown <= 0.0f) {
            Projectile proj = (Projectile)world.getLoader().create("laser");
            proj.rotate(this.getRotation() - 90.0f);
            Vector2f shipPos = new Vector2f();
            this.getCenter(shipPos);
            Vector2f shotCenter = new Vector2f();
            proj.getCenter(shotCenter);
            proj.setPos(shipPos.copy().sub(shotCenter).add(this.shipFront.copy().scale(120.0f)));
            proj.setVelocity(this.shipFront.copy().scale(2000.0f).add(this.velocity.copy()));
            proj.setShooter(this);
            Exclamation launch = (Exclamation)world.getLoader().create("zap_exclamation");
            launch.getCenter(shotCenter);
            launch.setPos(shipPos.copy().sub(shotCenter).add(this.shipFront.copy().scale(120.0f)));
            world.getEntities().add(launch);
            world.getEntities().add(proj);
            this.cooldown = 250.0f;
            this.playAudio("lazer", 1.0f);
        }
        Vector2f ep = this.getPos().copy();
        ep.x += 128.0f;
        ep.y += 220.0f;
        MathUtil.rotateAroundPoint(ep, this.getCenter(), this.getRotation());
        for (int i = 0; i < this.engineEmitters.length; ++i) {
            this.engineEmitters[i].setPosition(ep.x, ep.y);
            ((ConfigurableEmitter.SimpleValue)this.engineEmitters[i].angularOffset).setValue(this.getRotation() + 180.0f);
        }
        this.particles.update(dt);
    }

    public void render(Graphics g, GameWorld world, GameContainer container) {
        this.particles.render();
        this.applyTransform(g);
        super.render(g, world, container);
        this.applyInverseTransform(g);
    }

    public void debugRender(Graphics g, GameWorld world, GameContainer container) {
        super.debugRender(g, world, container);
        Vector2f from = new Vector2f(0.0f, 0.0f);
        Vector2f to = new Vector2f(500.0f, 500.0f);
        Vector2f hit = to.copy();
        List<SpatialQueryManager.RayHit> hits = world.getSpatialManager().rayCast(from, to);
        if (!hits.isEmpty()) {
            hits.get(0).pos(hit);
        }
        g.setColor(Color.green);
        g.drawLine(from.x, from.y, hit.x, hit.y);
        if (!hits.isEmpty()) {
            g.setColor(Color.red);
            g.drawLine(hit.x, hit.y, to.x, to.y);
            g.fillOval(hit.x - 5.0f, hit.y - 5.0f, 10.0f, 10.0f);
        }
        to = new Vector2f(50.0f, 0.0f);
        from = new Vector2f(550.0f, 500.0f);
        hit = to.copy();
        hits = world.getSpatialManager().rayCast(from, to);
        if (!hits.isEmpty()) {
            hits.get(0).pos(hit);
        }
        g.setColor(Color.green);
        g.drawLine(from.x, from.y, hit.x, hit.y);
        if (!hits.isEmpty()) {
            g.setColor(Color.red);
            g.drawLine(hit.x, hit.y, to.x, to.y);
            g.fillOval(hit.x - 5.0f, hit.y - 5.0f, 10.0f, 10.0f);
        }
    }

    public void registerWeaponPlatform(WeaponPlatform platform) {
        super.registerWeaponPlatform(platform);
        platform.setFireTarget(new FireTarget(){

            public boolean getFireTargetPosition(Vector2f positionOut) {
                positionOut.set(PlayerShip.this.targetPosition);
                return true;
            }
        });
        platform.setFireTrigger(new FireTrigger(){

            public boolean shouldFireAtWill() {
                return PlayerShip.this.isFiring;
            }
        });
    }
}

