/*
 * Decompiled with CFR 0.152.
 */
package game.entities;

import game.engine.loader.EntityDescriptor;
import game.engine.spatial.SpatialQueryManager;
import game.entities.BaseShip;
import game.entities.Entity;
import game.entities.Exclamation;
import game.entities.ScrapPart;
import game.entities.SpaceEntity;
import game.util.FireTarget;
import game.world.GameWorld;
import java.util.List;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.geom.Vector2f;

public class Projectile
extends SpaceEntity {
    private static float MAX_SPEED = 1.0f;
    private float ttl;
    private float power;
    private float volume;
    private BaseShip shooter;
    private String hitExclamation;

    public Projectile(EntityDescriptor descriptor) {
        super(descriptor);
        this.power = this.properties.getFloat("power", 20.0f);
        this.ttl = this.properties.getFloat("time_to_live", 5.0f);
        this.hitExclamation = (String)this.properties.get("hit_exclamation");
        this.volume = this.properties.getFloat("sound_volume", 1.0f);
    }

    public void setVelocity(Vector2f velocity) {
        this.velocity = velocity;
    }

    public void setShooter(BaseShip shooter) {
        this.shooter = shooter;
    }

    public void setTarget(FireTarget target) {
    }

    public void update(int dt, GameWorld world, GameContainer container) {
        this.ttl -= (float)dt / 1000.0f;
        if (this.ttl <= 0.0f) {
            world.getEntities().remove(this);
            return;
        }
        Vector2f from = new Vector2f();
        this.getCenter(from);
        from.sub(this.velocity.copy().normalise().scale(MAX_SPEED * (float)dt / 1000.0f));
        super.update(dt, world, container);
        Vector2f to = new Vector2f();
        this.getCenter(to);
        List<SpatialQueryManager.RayHit> hits = world.getSpatialManager().rayCast(from, to);
        if (!hits.isEmpty()) {
            for (SpatialQueryManager.RayHit hit : hits) {
                Entity entity = (Entity)hit.object.userData;
                if (entity instanceof ScrapPart) {
                    ScrapPart part = (ScrapPart)entity;
                    if (!part.isSocketed() || part.getSocket().getOwner() == this.shooter) continue;
                    part.onHit(this);
                    this.onCollided(world, hit.pos());
                    if (part.isSocketed()) break;
                    Exclamation detachCloud = (Exclamation)world.getLoader().create("detachcloud");
                    detachCloud.setPos(part.getPos());
                    world.getEntities().add(detachCloud);
                    break;
                }
                if (!(entity instanceof BaseShip)) continue;
                BaseShip ship = (BaseShip)entity;
                ship.onHit(this);
                if (ship.isDead()) {
                    world.getEntities().remove(ship);
                }
                this.onCollided(world, hit.pos());
                break;
            }
        }
    }

    private void onCollided(GameWorld world, Vector2f pos) {
        world.getEntities().remove(this);
        Exclamation ex = (Exclamation)world.getLoader().create(this.hitExclamation);
        ex.setPos(pos.sub(ex.getCenter()));
        world.getEntities().add(ex);
        if (this.sounds.contains("impact")) {
            this.playAudio("impact", this.volume);
        }
    }

    public float getPower() {
        return this.power;
    }
}

