/*
 * Decompiled with CFR 0.152.
 */
package game.entities;

import game.engine.loader.EntityDescriptor;
import game.engine.util.MathUtil;
import game.entities.Projectile;
import game.util.FireTarget;
import game.world.GameWorld;
import org.newdawn.slick.Color;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.geom.Vector2f;
import org.newdawn.slick.particles.ConfigurableEmitter;
import org.newdawn.slick.particles.ParticleSystem;

public class Rocket
extends Projectile {
    private float maxSpeed;
    private float acceleration;
    private float turnSpeed;
    private FireTarget target;
    private boolean isTurning;
    private float minTurnTime;
    private float maxTurnTime;
    private float airTime;
    private float maxTargetAngle;
    private ConfigurableEmitter smokeEmitter;
    private ParticleSystem particles;

    public Rocket(EntityDescriptor descriptor) {
        super(descriptor);
        this.maxSpeed = this.properties.getFloat("max_speed", 800.0f);
        this.acceleration = this.properties.getFloat("acceleration", 1000.0f);
        this.turnSpeed = this.properties.getFloat("turn_speed", 90.0f);
        this.minTurnTime = this.properties.getFloat("min_turn_time", 0.5f);
        this.maxTurnTime = this.properties.getFloat("max_turn_time", 2.0f);
        this.maxTargetAngle = this.properties.getFloat("max_target_angle", 1.0f);
        this.isTurning = true;
        this.airTime = 0.0f;
        this.smokeEmitter = descriptor.particleEmitters.get("missile_emitter").duplicate();
        this.particles = new ParticleSystem("assets/graphics/placeholder_particle.tga", 300);
        this.particles.addEmitter(this.smokeEmitter);
        this.disableTransformedRendering();
    }

    public void update(int dt, GameWorld world, GameContainer container) {
        super.update(dt, world, container);
        this.airTime += (float)dt / 1000.0f;
        if (this.airTime > this.minTurnTime) {
            this.isTurning = true;
        }
        Vector2f targetPosition = new Vector2f();
        if (this.airTime < this.maxTurnTime && this.isTurning && this.target != null && this.target.getFireTargetPosition(targetPosition)) {
            Vector2f rocketPosition = new Vector2f();
            this.getCenter(rocketPosition);
            targetPosition.sub(rocketPosition).normalise().sub(this.getRotation());
            float targetDirection = MathUtil.wrap((float)targetPosition.getTheta(), -180.0f, 180.0f);
            if (Math.abs(targetDirection) < this.maxTargetAngle) {
                this.isTurning = false;
            }
            float deltaRotation = Math.signum(targetDirection) * this.turnSpeed * (float)dt / 1000.0f;
            this.rotate(deltaRotation);
            this.velocity.add(deltaRotation);
        }
        Vector2f deltaVelocity = new Vector2f(this.acceleration * (float)dt / 1000.0f, 0.0f);
        deltaVelocity.add(this.getRotation());
        this.velocity.add(deltaVelocity);
        float speed = this.velocity.length();
        if (speed > this.maxSpeed) {
            this.velocity.scale(this.maxSpeed / speed);
        }
        Vector2f ep = this.getPos().copy();
        ep.x += 20.0f * this.getScale();
        ep.y += 102.0f * this.getScale();
        MathUtil.rotateAroundPoint(ep, this.getCenter(), this.getRotation());
        this.smokeEmitter.setPosition(ep.x, ep.y);
        ((ConfigurableEmitter.SimpleValue)this.smokeEmitter.angularOffset).setValue(this.getRotation());
        this.particles.update(dt);
    }

    public void setTarget(FireTarget target) {
        super.setTarget(target);
        this.target = target;
    }

    public void render(Graphics g, GameWorld world, GameContainer container) {
        this.particles.render();
        this.applyTransform(g);
        super.render(g, world, container);
        this.applyInverseTransform(g);
        g.setColor(Color.red);
        g.fillOval(this.smokeEmitter.getX() - 5.0f, this.smokeEmitter.getY() - 5.0f, 10.0f, 10.0f);
    }
}

