/*
 * Decompiled with CFR 0.152.
 */
package game.entities;

import game.engine.BoundingBox;
import game.engine.loader.EntityDescriptor;
import game.entities.Projectile;
import game.entities.SpaceEntity;
import game.util.BulletHitHandler;
import game.util.ScrapPartSocket;
import game.world.GameWorld;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.geom.Vector2f;

public class ScrapPart
extends SpaceEntity
implements BulletHitHandler {
    private static final int ATTACH_COOLDOWN = 1000;
    private final Vector2f temp = new Vector2f();
    private float health = this.maxHealth = this.properties.getFloat("max_health", 100.0f);
    private final float maxHealth;
    private float shakeAmplitude;
    private float shakeRotation = 0.0f;
    private float shakeTime = 0.0f;
    private ScrapPartSocket socket = null;
    private int coolDownBeforeReattach = 0;
    private float shakeMultiplier = this.properties.getFloat("shake_multiplier", 1.0f);
    private float shakeDuration = this.properties.getFloat("shake_duration", 0.2f);

    public ScrapPart(EntityDescriptor descriptor) {
        super(descriptor);
    }

    public void destroy(GameWorld world) {
        super.destroy(world);
    }

    public void update(int dt, GameWorld world, GameContainer container) {
        super.update(dt, world, container);
        this.velocity.x -= 0.8f * this.velocity.x * (float)dt / 1000.0f;
        this.velocity.y -= 0.8f * this.velocity.y * (float)dt / 1000.0f;
        BoundingBox bounds = this.getBounds();
        if (this.isSocketed()) {
            this.socket.getPosition(this.temp);
            this.temp.x -= bounds.getCenterX(0.0f, 0.0f);
            this.temp.y -= bounds.getCenterY(0.0f, 0.0f);
            this.setPos(this.temp);
            this.setRotation(this.socket.getRotation());
        } else {
            this.coolDownBeforeReattach -= dt;
        }
        this.shakeTime = Math.max(0.0f, this.shakeTime - (float)dt / 1000.0f);
    }

    public void setSocket(ScrapPartSocket socket) {
        this.socket = socket;
        if (socket.getSocketedPart() != this) {
            socket.setSocketedPart(this);
        }
    }

    public ScrapPartSocket getSocket() {
        return this.socket;
    }

    public boolean isSocketed() {
        return this.socket != null;
    }

    public void debugRender(Graphics g, GameWorld world, GameContainer container) {
        super.debugRender(g, world, container);
    }

    public void onHit(Projectile proj) {
        if (this.socket != null) {
            this.applyDamage(proj.getPower(), (float)proj.getVelocity().getTheta());
        }
    }

    public void applyDamage(float damage, float direction) {
        this.health -= damage;
        if (this.health <= 0.0f) {
            this.eject();
        }
        this.shakeRotation = direction;
        this.shakeAmplitude = damage * this.shakeMultiplier;
        this.shakeTime = this.shakeDuration;
    }

    public void eject() {
        this.socket.ejectPart();
        Vector2f ejectVelocity = new Vector2f(1.0f, 0.0f);
        ejectVelocity.setTheta(this.getRotation());
        ejectVelocity.scale(900.0f);
        this.coolDownBeforeReattach = 1000;
        this.velocity = ejectVelocity;
        this.socket = null;
        this.playAudio("detach", 1.0f);
    }

    public void resetHealth() {
        this.health = 100.0f;
    }

    protected int getRenderBin() {
        return super.getRenderBin() - (this.socket == null ? 0 : this.socket.getLayer() + 1);
    }

    public boolean isAttachable() {
        return this.coolDownBeforeReattach < 0;
    }

    public void addVelocity(Vector2f dv) {
        this.velocity.add(dv);
    }

    protected void getDebugText(StringBuilder sb) {
        super.getDebugText(sb);
        sb.append(String.format("CD: %.1fs\n", Float.valueOf((float)this.coolDownBeforeReattach / 1000.0f)));
        sb.append("S: " + this.isSocketed() + "\n");
    }

    protected void applyTransform(Graphics g) {
        float shakeOffset = (float)Math.sin((double)(this.shakeTime * 2.0f) * Math.PI / (double)this.shakeDuration) * this.shakeAmplitude;
        Vector2f temp = new Vector2f(shakeOffset, 0.0f);
        temp.add(this.shakeRotation);
        g.translate(Math.round(temp.x), Math.round(temp.y));
        super.applyTransform(g);
    }

    protected void applyInverseTransform(Graphics g) {
        float shakeOffset = (float)Math.sin((double)(this.shakeTime * 2.0f) * Math.PI / (double)this.shakeDuration) * this.shakeAmplitude;
        Vector2f temp = new Vector2f(shakeOffset, 0.0f);
        temp.add(this.shakeRotation);
        g.translate(-Math.round(temp.x), -Math.round(temp.y));
        super.applyInverseTransform(g);
    }
}

