/*
 * Decompiled with CFR 0.152.
 */
package game.entities;

import game.engine.BoundingBox;
import game.engine.loader.EntityDescriptor;
import game.engine.spatial.CircleShape;
import game.engine.spatial.SpatialObject;
import game.entities.Entity;
import game.world.GameWorld;
import org.newdawn.slick.Color;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.geom.Vector2f;

public abstract class SpaceEntity
extends Entity {
    protected Vector2f velocity = new Vector2f(0.0f, 0.0f);
    private final float collisionSphereRadius = this.properties.getFloat("collision_sphere_radius", 0.0f);
    private SpatialObject spatialObject = null;

    public SpaceEntity(EntityDescriptor descriptor) {
        super(descriptor);
    }

    public void update(int dt, GameWorld world, GameContainer container) {
        super.update(dt, world, container);
        this.translate(this.velocity.x * (float)dt / 1000.0f, this.velocity.y * (float)dt / 1000.0f);
        if (this.spatialObject != null) {
            this.spatialObject.position.set(this.getPos());
        }
    }

    public void debugRender(Graphics g, GameWorld world, GameContainer container) {
        super.debugRender(g, world, container);
        BoundingBox bounds = this.getBounds();
        if (bounds != null) {
            float cx = bounds.getCenterX(this.getPos());
            float cy = bounds.getCenterY(this.getPos());
            g.setColor(Color.yellow);
            g.drawLine(cx, cy, cx + this.velocity.x, cy + this.velocity.y);
        }
    }

    public Vector2f getVelocity() {
        return this.velocity;
    }

    protected void getDebugText(StringBuilder sb) {
        super.getDebugText(sb);
        sb.append(String.format("V: %.1f\n", Float.valueOf(this.velocity.length())));
    }

    public void init(GameWorld world) {
        super.init(world);
        if (this.collisionSphereRadius > 0.0f) {
            BoundingBox bb = this.getBounds();
            Vector2f offset = new Vector2f(bb.getCenterX(0.0f, 0.0f), bb.getCenterY(0.0f, 0.0f));
            this.spatialObject = new SpatialObject(this, new CircleShape(offset, this.collisionSphereRadius));
            world.getSpatialManager().add(this.spatialObject);
        }
    }

    public void destroy(GameWorld world) {
        super.destroy(world);
        if (this.spatialObject != null) {
            world.getSpatialManager().remove(this.spatialObject);
            this.spatialObject = null;
        }
    }
}

