/*
 * Decompiled with CFR 0.152.
 */
package game.entities;

import game.engine.loader.EntityDescriptor;
import game.engine.util.MathUtil;
import game.entities.Projectile;
import game.entities.ScrapPart;
import game.util.FireTarget;
import game.util.FireTrigger;
import game.util.ScrapPartSocket;
import game.util.WeaponPlatform;
import game.world.GameWorld;
import java.util.ArrayList;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.geom.Vector2f;

public class WeaponizedScrapPart
extends ScrapPart
implements WeaponPlatform {
    private String projectileName;
    private float cooldown;
    private float aimAngle;
    private float volume;
    private boolean onlyInView;
    private ArrayList<ProjectileInfo> projectiles;
    private float currentCooldown;
    private float currentDelay;
    private FireTarget target;
    private FireTrigger trigger;

    public WeaponizedScrapPart(EntityDescriptor descriptor) {
        super(descriptor);
        this.projectileName = (String)this.properties.get("projectile");
        this.cooldown = this.properties.getFloat("cooldown", 1.0f);
        this.aimAngle = this.properties.getFloat("aim_angle", 0.0f);
        this.onlyInView = this.properties.getBoolean("only_in_view", false);
        this.volume = this.properties.getFloat("sound_volume", 1.0f);
        this.projectiles = new ArrayList();
        int count = this.properties.getInt("projectile_count", 1);
        float[] delays = this.properties.getFloatArray("projectile_delays", 0.0f);
        float[] offsets = this.properties.getFloatArray("projectile_offsets", 0.0f, 0.0f);
        float[] angles = this.properties.getFloatArray("projectile_angles", 0.0f);
        float[] velocities = this.properties.getFloatArray("projectile_velocities", 100.0f);
        for (int i = 0; i < count; ++i) {
            float delay = delays[i];
            Vector2f offset = new Vector2f(offsets[2 * i], offsets[2 * i + 1]);
            float angle = angles[i];
            float velocity = velocities[i];
            this.projectiles.add(new ProjectileInfo(delay, offset, angle, velocity));
        }
        this.currentCooldown = 0.0f;
    }

    public void setFireTarget(FireTarget target) {
        this.target = target;
    }

    public void setFireTrigger(FireTrigger trigger) {
        this.trigger = trigger;
    }

    public void update(int dt, GameWorld world, GameContainer container) {
        super.update(dt, world, container);
        this.currentCooldown = Math.max(0.0f, this.currentCooldown - (float)dt / 1000.0f);
        float oldDelay = this.currentDelay;
        this.currentDelay += (float)dt / 1000.0f;
        float shootAngle = this.getRotation();
        boolean inRange = true;
        Vector2f targetPosition = new Vector2f();
        if (this.target != null && this.target.getFireTargetPosition(targetPosition)) {
            Vector2f weaponPosition = new Vector2f();
            this.getCenter(weaponPosition);
            Vector2f targetDirection = targetPosition.copy().sub(weaponPosition).normalise();
            float weaponAngle = this.getRotation();
            targetDirection.sub(weaponAngle);
            float deltaAimAngle = MathUtil.wrap((float)targetDirection.getTheta(), -180.0f, 180.0f);
            if (deltaAimAngle < -this.aimAngle) {
                deltaAimAngle = -this.aimAngle;
                inRange = false;
            } else if (deltaAimAngle > this.aimAngle) {
                deltaAimAngle = this.aimAngle;
                inRange = false;
            }
            shootAngle = weaponAngle + deltaAimAngle;
        }
        if (this.isSocketed()) {
            if (this.currentCooldown <= 0.0f && this.trigger != null && this.trigger.shouldFireAtWill() && (!this.onlyInView || inRange)) {
                this.currentCooldown = this.cooldown;
                oldDelay = -1.0f;
                this.currentDelay = 0.0f;
            }
            if (this.currentCooldown > 0.0f) {
                for (ProjectileInfo info : this.projectiles) {
                    if (!(oldDelay < info.delay) || !(this.currentDelay >= info.delay)) continue;
                    Projectile proj = (Projectile)world.getLoader().create(this.projectileName);
                    proj.rotate(shootAngle + info.angle);
                    proj.setTarget(this.target);
                    Vector2f spawnPos = new Vector2f();
                    this.getCenter(spawnPos);
                    Vector2f temp = new Vector2f();
                    proj.getCenter(temp);
                    spawnPos.sub(temp);
                    temp.set(info.offset);
                    temp.add(this.getRotation());
                    spawnPos.add(temp);
                    proj.setPos(spawnPos);
                    Vector2f direction = new Vector2f(info.velocity, 0.0f);
                    direction.add(shootAngle + info.angle);
                    proj.setVelocity(direction);
                    proj.setShooter(this.getSocket().getOwner());
                    world.getEntities().add(proj);
                    if (!this.sounds.contains("fire")) continue;
                    this.playAudio("fire", this.volume);
                }
            }
        }
    }

    public void setSocket(ScrapPartSocket socket) {
        this.target = null;
        this.trigger = null;
        super.setSocket(socket);
        socket.registerWeaponPlatform(this);
    }

    private static class ProjectileInfo {
        public final float delay;
        public final Vector2f offset;
        public final float angle;
        public final float velocity;

        public ProjectileInfo(float delay, Vector2f offset, float angle, float velocity) {
            this.delay = delay;
            this.offset = offset.copy();
            this.angle = angle;
            this.velocity = velocity;
        }
    }
}

