/*
 * Decompiled with CFR 0.152.
 */
package game.util;

import game.entities.BaseShip;
import game.entities.ScrapPart;
import game.util.SocketLayers;
import game.util.WeaponPlatform;
import org.newdawn.slick.geom.Vector2f;

public class ScrapPartSocket {
    private Vector2f offsetPos;
    private float offsetRotation;
    private BaseShip owner;
    private SocketLayers sockets;
    private ScrapPart scrap;
    private final Vector2f temp = new Vector2f();
    private int layer;

    public ScrapPartSocket(SocketLayers sockets, BaseShip owner, Vector2f offsetPos, int layer, float offsetRotation) {
        this.sockets = sockets;
        this.owner = owner;
        this.scrap = null;
        this.layer = layer;
        this.offsetPos = offsetPos.copy();
        this.offsetRotation = offsetRotation;
    }

    public BaseShip getOwner() {
        return this.owner;
    }

    public void getPosition(Vector2f positionOut) {
        this.owner.getCenter(this.temp);
        positionOut.set(this.offsetPos);
        positionOut.add(this.owner.getRotation() + this.sockets.getRotation());
        positionOut.add(this.temp);
    }

    public float getRotation() {
        return this.owner.getRotation() + this.offsetRotation + this.sockets.getRotation();
    }

    public void setSocketedPart(ScrapPart scrap) {
        this.scrap = scrap;
        if (scrap.getSocket() != this) {
            scrap.setSocket(this);
        }
    }

    public ScrapPart getSocketedPart() {
        return this.scrap;
    }

    public boolean isOccupied() {
        return this.scrap != null;
    }

    public Vector2f getOffsetPosition() {
        return this.offsetPos;
    }

    public void ejectPart() {
        this.scrap = null;
    }

    public float getOffsetRotation() {
        return this.offsetRotation;
    }

    public int getLayer() {
        return this.layer;
    }

    public void registerWeaponPlatform(WeaponPlatform platform) {
        this.owner.registerWeaponPlatform(platform);
    }
}

