/*
 * Decompiled with CFR 0.152.
 */
package game.util;

import game.entities.BaseShip;
import game.entities.ScrapPart;
import game.util.ScrapPartSocket;
import game.world.GameWorld;
import java.util.Iterator;
import org.newdawn.slick.geom.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SocketLayers
implements Iterable<ScrapPartSocket> {
    private ScrapPartSocket[][] layers;
    private float rotation = 0.0f;

    public void construct(GameWorld world, BaseShip ship, int socketLayers) {
        this.layers = new ScrapPartSocket[socketLayers][];
        for (int layer = this.layers.length - 1; layer >= 0; --layer) {
            this.layers[layer] = new ScrapPartSocket[this.nbrSocketsInLayer(layer)];
            int layerRadius = this.getLayerRadius(layer);
            float layerDeltaTheta = this.getLayerDeltaTheta(layer);
            Vector2f socketSpawnPos = new Vector2f(1.0f, 0.0f);
            socketSpawnPos.scale(layerRadius);
            float theta = 0.0f;
            for (int i = 0; i < this.layers[layer].length; ++i) {
                socketSpawnPos.setTheta(theta);
                this.layers[layer][i] = new ScrapPartSocket(this, ship, socketSpawnPos, layer, theta);
                theta += layerDeltaTheta;
            }
        }
    }

    public ScrapPartSocket getInnermostEmpty() {
        for (int layer = 0; layer < this.layers.length; ++layer) {
            for (int i = 0; i < this.layers[layer].length; ++i) {
                ScrapPartSocket sps = this.layers[layer][i];
                if (sps.isOccupied()) continue;
                return sps;
            }
        }
        return null;
    }

    public int getOutermostPopulatedLayer() {
        for (int layer = this.layers.length - 1; layer >= 0; --layer) {
            for (int i = 0; i < this.layers[layer].length; ++i) {
                if (!this.layers[layer][i].isOccupied()) continue;
                return layer + 1;
            }
        }
        return 0;
    }

    public int getNormalPopulatedLayer() {
        int count = 0;
        int max = 0;
        for (int layer = this.layers.length - 1; layer >= 0; --layer) {
            for (int i = 0; i < this.layers[layer].length; ++i) {
                ++max;
                if (!this.layers[layer][i].isOccupied()) continue;
                ++count;
            }
        }
        return this.layers.length * count / max;
    }

    private int nbrSocketsInLayer(int layer) {
        return (layer + 1) * 4;
    }

    private int getLayerRadius(int layer) {
        return (layer + 1) * 110;
    }

    private float getLayerDeltaTheta(int layer) {
        return 360.0f / (float)this.nbrSocketsInLayer(layer);
    }

    public void populateLayer(GameWorld world, int layer, Iterator<String> iterator) {
        for (int i = 0; i < this.layers[layer].length && iterator.hasNext(); ++i) {
            String entityName = iterator.next();
            ScrapPart part = (ScrapPart)world.getLoader().create(entityName);
            world.getEntities().add(part);
            this.layers[layer][i].setSocketedPart(part);
        }
    }

    @Override
    public Iterator<ScrapPartSocket> iterator() {
        return new Iterator<ScrapPartSocket>(){
            private int layer = 0;
            private int i = 0;

            @Override
            public boolean hasNext() {
                return this.layer < SocketLayers.this.layers.length;
            }

            @Override
            public ScrapPartSocket next() {
                ScrapPartSocket ret = SocketLayers.this.layers[this.layer][this.i];
                ++this.i;
                if (this.i == SocketLayers.this.layers[this.layer].length) {
                    ++this.layer;
                    this.i = 0;
                }
                return ret;
            }

            @Override
            public void remove() {
                throw new RuntimeException("Not supported.");
            }
        };
    }

    public float getRotation() {
        return this.rotation;
    }

    public void setRotation(float rotation) {
        this.rotation = rotation;
    }

    public void rotate(float deltaRotation) {
        this.rotation += deltaRotation;
    }

    public int getPopulatedRadius() {
        return 110 * this.getOutermostPopulatedLayer() + 64;
    }

    public float getOccupiedCount() {
        int count = 0;
        for (int layer = this.layers.length - 1; layer >= 0; --layer) {
            for (int i = 0; i < this.layers[layer].length; ++i) {
                if (!this.layers[layer][i].isOccupied()) continue;
                ++count;
            }
        }
        return count;
    }
}

