/*
 * Decompiled with CFR 0.152.
 */
package game.world;

import game.GameConfig;
import game.engine.BaseGameWorld;
import game.engine.BoundingBox;
import game.engine.KeepInViewCamera;
import game.engine.input.MouseEvent;
import game.engine.loader.EntityLoader;
import game.engine.util.ObjectManager;
import game.entities.BossShip;
import game.entities.Entity;
import game.entities.ParallaxBackground;
import game.entities.PlayerShip;
import java.util.List;
import java.util.ListIterator;
import org.newdawn.slick.Color;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.geom.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GameWorld
extends BaseGameWorld<Entity> {
    private static final BoundingBox EMPTY_BOUNDS = new BoundingBox(0.0f, 0.0f);
    private boolean debugEntities;
    private boolean debugSpatial;
    private final GameConfig config;
    private KeepInViewCamera camera;
    private PlayerShip player;
    private BossShip boss;

    public GameWorld(EntityLoader loader, GameConfig config, GameContainer container) {
        super(loader, container, new KeepInViewCamera(), Entity.class);
        this.camera = (KeepInViewCamera)((BaseGameWorld)this).camera;
        this.config = config;
        this.debugEntities = false;
        this.debugSpatial = false;
        this.player = (PlayerShip)loader.create("player");
        this.objects.add(this.player);
        this.boss = (BossShip)loader.create("boss");
        this.objects.add(this.boss);
        this.player.setPos(-1000.0f, -800.0f);
        this.boss.setPos(0.0f, 0.0f);
        this.boss.setEnemy(this.player);
        this.player.setEnemy(this.boss);
        this.camera.addEntity(this.player);
        this.camera.addEntity(this.boss);
        this.camera.setMargin(512.0f);
        this.camera.setScaleLimits(0.1f, 1.5f);
        this.objects.add((ParallaxBackground)loader.create("background"));
    }

    public void update(int dt, GameContainer container) {
        this.internalUpdate(dt);
        if (container.getInput().isKeyPressed(88)) {
            boolean bl = this.debugEntities = !this.debugEntities;
        }
        if (container.getInput().isKeyPressed(87)) {
            this.debugSpatial = !this.debugSpatial;
            this.getSpatialManager().setDebugEnabled(this.debugSpatial);
        }
        for (Entity o : this.objects.get()) {
            o.update(dt, this, container);
        }
    }

    public void render(Graphics g, GameContainer container) {
        g.pushTransform();
        this.camera.applyTransform(g, container);
        g.pushTransform();
        List objs = this.getRenderList();
        for (Entity o : objs) {
            g.pushTransform();
            if (o.preRender(g, this, container)) {
                o.render(g, this, container);
                o.postRender(g, this, container);
            }
            g.popTransform();
        }
        if (this.debugEntities) {
            g.setFont(container.getDefaultFont());
            for (Entity o : objs) {
                o.debugRender(g, this, container);
            }
        }
        g.popTransform();
        g.popTransform();
        g.pushTransform();
        if (this.debugSpatial) {
            this.camera.applyTransform(g, container);
            this.getSpatialManager().debugRender(g);
        }
        g.popTransform();
        if (this.debugEntities) {
            g.pushTransform();
            g.setFont(container.getDefaultFont());
            g.translate((float)container.getWidth() - 200.0f, 0.0f);
            g.setColor(new Color(0.0f, 0.0f, 0.0f, 0.8f));
            g.fillRect(0.0f, 0.0f, 200.0f, 300.0f);
            g.setColor(Color.black);
            g.drawRect(0.0f, 0.0f, 200.0f, 300.0f);
            g.setColor(Color.white);
            g.drawString("Debug overlay", 0.0f, 0.0f);
            g.translate(0.0f, g.getFont().getLineHeight());
            g.scale(0.75f, 0.75f);
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("Entity count: %d\n", this.objects.size()));
            g.drawString(sb.toString(), 0.0f, 0.0f);
            g.popTransform();
        }
    }

    public ObjectManager<Entity> getEntities() {
        return this.objects;
    }

    @Override
    protected void onEntityAdded(Entity entity) {
        entity.init(this);
    }

    @Override
    protected void onEntityRemoved(Entity entity) {
        entity.destroy(this);
    }

    @Override
    protected void onMouseEvent(MouseEvent event) {
        List objs = this.getRenderList();
        ListIterator it = objs.listIterator(objs.size());
        while (it.hasPrevious()) {
            Entity entity = (Entity)it.previous();
            if (event.consumed()) break;
            BoundingBox bb = entity.getBounds();
            Vector2f v = entity.getPos();
            if (bb == null) {
                bb = EMPTY_BOUNDS;
            }
            entity.handleMouseEvent(this, event.localized(bb.getMinX(v), bb.getMinY(v), bb.getWidth(), bb.getHeight(), entity.getScale()));
        }
    }

    public GameConfig getConfig() {
        return this.config;
    }

    public boolean isVictorious() {
        return this.boss.isDead() || this.boss.isDestroyed();
    }

    public boolean isDefeated() {
        return this.player.isDead() || this.player.isDestroyed();
    }
}

