/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.GameConfig;
import game.LudumDareGameOverState;
import game.LudumDareGameplayState;
import game.LudumDareHandWashState;
import game.LudumDareTitleState;
import game.LudumDareVictoryState;
import game.engine.config.ConfigException;
import game.engine.config.ConfigLoader;
import game.engine.loader.EntityLoader;
import game.engine.util.CustomClasspathLocation;
import game.engine.util.LWJGLException;
import game.engine.util.LWJGLInstaller;
import game.engine.util.OperatingSystem;
import game.engine.util.RestrictedResourceLocation;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.swing.JOptionPane;
import org.newdawn.slick.AppGameContainer;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.opengl.renderer.Renderer;
import org.newdawn.slick.state.StateBasedGame;
import org.newdawn.slick.util.FileSystemLocation;
import org.newdawn.slick.util.ResourceLoader;

public class LudumDareGame
extends StateBasedGame {
    public static final GameConfig config = new GameConfig();
    public static final String GAME_TITLE = "Ludum Dare #29 Game";
    public static final String GAME_ID = "LudumDare29";
    private Image endScreen;
    public static final float DEFAULT_MUSIC_GAIN = 1.0f;

    public LudumDareGame() {
        super(GAME_TITLE);
    }

    public void initStatesList(GameContainer container) throws SlickException {
        if (!LudumDareGame.config.dev) {
            container.setShowFPS(false);
        }
        if (!LudumDareGame.config.bench) {
            container.setTargetFrameRate(60);
        }
        EntityLoader loader = new EntityLoader("assets/xml");
        this.addState(new LudumDareTitleState(loader));
        this.addState(new LudumDareGameplayState(loader));
        this.addState(new LudumDareHandWashState(loader));
        this.addState(new LudumDareGameOverState(loader));
        this.addState(new LudumDareVictoryState(loader));
    }

    public void setEndScreen(Image image) {
        this.endScreen = image;
    }

    public Image getEndScreen() {
        return this.endScreen;
    }

    public static void main(String[] args) throws SlickException {
        LudumDareGame.loadConfiguration(args);
        LudumDareGame.setupResourceLoader();
        Renderer.setRenderer(2);
        if (!LudumDareGame.config.skipinstall && !LudumDareGame.setupNativeLibraries()) {
            System.exit(1);
        }
        LudumDareGame game = new LudumDareGame();
        AppGameContainer gameContainer = new AppGameContainer(game, 800, 600, false);
        gameContainer.start();
    }

    private static void setupResourceLoader() {
        ResourceLoader.removeAllResourceLocations();
        CustomClasspathLocation classpathLocation = new CustomClasspathLocation();
        ResourceLoader.addResourceLocation(new RestrictedResourceLocation(classpathLocation, "natives/"));
        ResourceLoader.addResourceLocation(new RestrictedResourceLocation(classpathLocation, "org/newdawn/slick/data/"));
        if (LudumDareGame.config.externaldatapath.isEmpty()) {
            ResourceLoader.addResourceLocation(new RestrictedResourceLocation(classpathLocation, "assets/"));
        } else {
            FileSystemLocation assetLocation = new FileSystemLocation(new File(LudumDareGame.config.externaldatapath));
            ResourceLoader.addResourceLocation(new RestrictedResourceLocation(assetLocation, "assets/", ""));
        }
    }

    private static void loadConfiguration(String[] args) throws SlickException {
        try {
            try {
                ConfigLoader.loadProperties(config, LudumDareGame.class.getClassLoader().getResourceAsStream("default.properties"));
            }
            catch (IOException e) {
                throw new SlickException("The default.properties configuration file could not be read.", e);
            }
            ConfigLoader.loadArgs(config, args);
            if (!LudumDareGame.config.skipinstall) {
                File gameDir = LudumDareGame.getGameDirectory();
                File configFile = new File(gameDir, "config.properties");
                if (gameDir.exists() && gameDir.isDirectory() || gameDir.mkdirs()) {
                    try {
                        if (configFile.exists() && configFile.isFile()) {
                            ConfigLoader.loadProperties(config, new FileInputStream(configFile));
                        } else {
                            configFile.createNewFile();
                        }
                    }
                    catch (IOException e) {
                        System.err.println("Warning! Could not load or create the game config file " + configFile.getAbsolutePath() + ".");
                    }
                }
            }
            ConfigLoader.loadArgs(config, args);
        }
        catch (ConfigException e) {
            System.err.println("Could not load configuration.");
            System.err.println(e.getMessage());
            throw new SlickException("Failed to load configuration.", e);
        }
    }

    private static boolean setupNativeLibraries() {
        File gameDir = LudumDareGame.getGameDirectory();
        LWJGLInstaller installer = new LWJGLInstaller(gameDir);
        installer.setOperatingSystemArchive(OperatingSystem.windows, "natives/windows_natives.jar");
        installer.setOperatingSystemArchive(OperatingSystem.linux, "natives/linux_natives.jar");
        installer.setOperatingSystemArchive(OperatingSystem.macosx, "natives/macosx_natives.jar");
        installer.setOperatingSystemArchive(OperatingSystem.solaris, "natives/solaris_natives.jar");
        OperatingSystem os = OperatingSystem.getCurrentOperatingSystem();
        if (os == null) {
            os = (OperatingSystem)((Object)JOptionPane.showInputDialog(null, "Your operating system could not be detected.\nPlease choose the closest match below.", "Cannot detect operating system", 1, null, (Object[])OperatingSystem.values(), (Object)OperatingSystem.windows));
        }
        if (os == null) {
            return false;
        }
        try {
            installer.install(os);
            return true;
        }
        catch (LWJGLException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "Could not install native libraries.\n" + e.getMessage());
            return false;
        }
    }

    private static File getGameDirectory() {
        return new File(System.getProperty("user.home"), GAME_ID);
    }
}

