/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.LudumDareGame;
import game.LudumDareGameState;
import game.LudumDareHandWashState;
import game.engine.BoundingBox;
import game.engine.loader.EntityLoader;
import game.engine.util.AnimatedTransition;
import game.entities.Player;
import game.world.LDGameWorld;
import org.newdawn.slick.Animation;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.openal.Audio;
import org.newdawn.slick.state.BasicGameState;
import org.newdawn.slick.state.StateBasedGame;

public class LudumDareGameplayState
extends BasicGameState {
    private LDGameWorld world;
    private EntityLoader loader;
    private Animation smashSpace;
    private Audio bgm;

    public LudumDareGameplayState(EntityLoader loader) {
        this.loader = loader;
        this.smashSpace = loader.getAnimation("smash_space");
        this.bgm = loader.getSound("maingame_loop");
    }

    public void init(GameContainer container, StateBasedGame game) throws SlickException {
        this.createWorld(container);
    }

    private void createWorld(GameContainer container) {
        this.world = new LDGameWorld(this.loader, LudumDareGame.config, container);
    }

    public void render(GameContainer container, StateBasedGame game, Graphics g) throws SlickException {
        this.world.render(g, container);
        if (this.world.getPlayer().isShakingHands()) {
            BoundingBox box = this.world.getCamera().getScreenBounds();
            g.drawAnimation(this.smashSpace, (box.getWidth() - (float)this.smashSpace.getWidth()) / 2.0f, box.getHeight() - (float)this.smashSpace.getHeight());
        }
    }

    public void update(GameContainer container, StateBasedGame game, int dt) throws SlickException {
        this.world.update(dt, container);
        if (this.world.isVictoryAchieved()) {
            game.getState(LudumDareGameState.victory.ordinal()).enter(container, game);
            game.getState(LudumDareGameState.victory.ordinal()).update(container, game, 1);
            game.enterState(LudumDareGameState.victory.ordinal(), new AnimatedTransition(this.loader.getAnimation("transition_out")), new AnimatedTransition(this.loader.getAnimation("transition_in")));
        } else if (this.world.getGameOver()) {
            game.getState(LudumDareGameState.gameover.ordinal()).enter(container, game);
            game.getState(LudumDareGameState.gameover.ordinal()).update(container, game, 1);
            game.enterState(LudumDareGameState.gameover.ordinal(), new AnimatedTransition(this.loader.getAnimation("transition_out")), new AnimatedTransition(this.loader.getAnimation("transition_in")));
        } else if (this.world.isPlayerWashingHands()) {
            ((LudumDareHandWashState)game.getState(LudumDareGameState.washhands.ordinal())).setGolden(this.world.isPlayerUsingGolden());
            this.world.setIsWashingHands(false, false);
            game.getState(LudumDareGameState.washhands.ordinal()).enter(container, game);
            game.getState(LudumDareGameState.washhands.ordinal()).update(container, game, 1);
            game.enterState(LudumDareGameState.washhands.ordinal(), new AnimatedTransition(this.loader.getAnimation("transition_out")), new AnimatedTransition(this.loader.getAnimation("transition_in")));
        } else if (this.world.isInLevelTransition()) {
            game.enterState(LudumDareGameState.game.ordinal(), new AnimatedTransition(this.loader.getAnimation("transition_out")), new AnimatedTransition(this.loader.getAnimation("transition_in")));
            this.createWorld(container);
        }
    }

    public int getID() {
        return LudumDareGameState.game.ordinal();
    }

    public void enter(GameContainer container, StateBasedGame game) throws SlickException {
        this.bgm.playAsMusic(1.0f, 1.0f, true);
    }

    public void leave(GameContainer container, StateBasedGame game) throws SlickException {
        super.leave(container, game);
        this.bgm.stop();
        Image endScreen = new Image(container.getWidth(), container.getHeight());
        Graphics g = endScreen.getGraphics();
        this.render(container, game, g);
        g.flush();
        ((LudumDareGame)game).setEndScreen(endScreen);
    }

    public Player getPlayer() {
        return this.world.getPlayer();
    }
}

