/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.LudumDareGame;
import game.LudumDareGameState;
import game.LudumDareGameplayState;
import game.engine.loader.EntityLoader;
import game.engine.util.AnimatedTransition;
import game.world.HandWashingGameWorld;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.openal.Audio;
import org.newdawn.slick.state.BasicGameState;
import org.newdawn.slick.state.StateBasedGame;

public class LudumDareHandWashState
extends BasicGameState {
    private HandWashingGameWorld world;
    private EntityLoader loader;
    private Audio bgm;
    private Audio sfx_water;

    public LudumDareHandWashState(EntityLoader loader) {
        this.loader = loader;
        this.bgm = loader.getSound("washing_loop");
        this.sfx_water = loader.getSound("sfx_tap_loop");
    }

    public void init(GameContainer container, StateBasedGame game) throws SlickException {
        this.world = new HandWashingGameWorld(this.loader, LudumDareGame.config, container);
    }

    public void render(GameContainer container, StateBasedGame game, Graphics g) throws SlickException {
        this.world.render(g, container);
    }

    public void update(GameContainer container, StateBasedGame game, int dt) throws SlickException {
        this.world.update(dt, container);
        if (this.world.isGameFinished()) {
            ((LudumDareGameplayState)game.getState(LudumDareGameState.game.ordinal())).getPlayer().setGermLevel(this.world.getPlayerGermLevel());
            game.enterState(LudumDareGameState.game.ordinal(), new AnimatedTransition(this.loader.getAnimation("transition_out")), new AnimatedTransition(this.loader.getAnimation("transition_in")));
        }
    }

    public int getID() {
        return LudumDareGameState.washhands.ordinal();
    }

    public void enter(GameContainer container, StateBasedGame game) throws SlickException {
        super.enter(container, game);
        float playerGermLevel = ((LudumDareGameplayState)game.getState(LudumDareGameState.game.ordinal())).getPlayer().getGermLevel();
        this.world.resetHandWashing(playerGermLevel);
        this.bgm.playAsMusic(1.0f, 1.0f, true);
    }

    public void leave(GameContainer container, StateBasedGame game) throws SlickException {
        super.leave(container, game);
        this.bgm.stop();
        System.out.println("left");
        Image endScreen = new Image(container.getWidth(), container.getHeight());
        Graphics g = endScreen.getGraphics();
        this.render(container, game, g);
        g.flush();
        ((LudumDareGame)game).setEndScreen(endScreen);
    }

    public void setGolden(boolean isGolden) {
        this.world.setGolden(isGolden);
    }
}

