/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.LudumDareGameState;
import game.engine.loader.EntityLoader;
import game.engine.util.AnimatedTransition;
import java.util.ArrayList;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.Input;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.openal.Audio;
import org.newdawn.slick.state.BasicGameState;
import org.newdawn.slick.state.StateBasedGame;

public class LudumDareTitleState
extends BasicGameState {
    private static final String PATH_ASSETS = "assets/graphics";
    private EntityLoader loader;
    private Image background;
    private ArrayList<Button> buttons;
    private int selectedButton;
    private State state;
    private Image controls;
    private Image intro;
    private Audio bgm;

    public LudumDareTitleState(EntityLoader loader) {
        this.loader = loader;
        this.bgm = loader.getSound("menu_loop");
    }

    public void init(GameContainer container, StateBasedGame game) throws SlickException {
        this.state = State.menu;
        this.buttons = new ArrayList();
        this.background = this.load("title_screen");
        this.controls = this.load("control_screen");
        this.intro = this.load("intro_comic");
        this.selectedButton = 0;
        this.addButton("start", "start_selected", State.start);
        this.addButton("controls", "controls_selected", State.controls);
        this.addButton("quit", "quit_selected", State.quit);
    }

    public void update(GameContainer container, StateBasedGame game, int delta) throws SlickException {
        Input input = container.getInput();
        switch (this.state) {
            case menu: {
                if (input.isKeyPressed(208)) {
                    this.selectedButton = (this.selectedButton + 1) % this.buttons.size();
                    this.loader.getSound("sfx_select").playAsSoundEffect(1.0f, 1.0f, false);
                }
                if (input.isKeyPressed(200)) {
                    this.selectedButton = (this.selectedButton + this.buttons.size() - 1) % this.buttons.size();
                    this.loader.getSound("sfx_select").playAsSoundEffect(1.0f, 1.0f, false);
                }
                if (LudumDareGameState.isEscapeKeyPressed(input)) {
                    this.state = State.quit;
                    break;
                }
                if (!LudumDareGameState.isAcceptKeyPressed(input)) break;
                this.state = this.buttons.get((int)this.selectedButton).state;
                this.loader.getSound("sfx_accept").playAsSoundEffect(1.0f, 1.0f, false);
                break;
            }
            case controls: {
                if (!LudumDareGameState.isAcceptKeyPressed(input) && !LudumDareGameState.isCancelKeyPressed(input)) break;
                this.state = State.menu;
                this.loader.getSound("sfx_accept").playAsSoundEffect(1.0f, 1.0f, false);
                break;
            }
            case quit: {
                container.exit();
                break;
            }
            case start: {
                if (LudumDareGameState.isCancelKeyPressed(input)) {
                    this.state = State.menu;
                    this.loader.getSound("sfx_accept").playAsSoundEffect(1.0f, 1.0f, false);
                    break;
                }
                if (!LudumDareGameState.isAcceptKeyPressed(input)) break;
                this.loader.getSound("sfx_accept").playAsSoundEffect(1.0f, 1.0f, false);
                game.getState(LudumDareGameState.game.ordinal()).init(container, game);
                game.getState(LudumDareGameState.game.ordinal()).update(container, game, 1);
                game.enterState(LudumDareGameState.game.ordinal(), new AnimatedTransition(this.loader.getAnimation("transition_out")), new AnimatedTransition(this.loader.getAnimation("transition_in")));
            }
        }
        input.clearKeyPressedRecord();
        input.clearMousePressedRecord();
    }

    public void enter(GameContainer container, StateBasedGame game) throws SlickException {
        super.enter(container, game);
        this.state = State.menu;
        this.bgm.playAsMusic(1.0f, 1.0f, true);
    }

    public void leave(GameContainer container, StateBasedGame game) throws SlickException {
        this.bgm.stop();
    }

    public void render(GameContainer container, StateBasedGame game, Graphics g) throws SlickException {
        if (this.state == State.menu) {
            g.drawImage(this.background, 0.0f, 0.0f);
            float x = 100.0f;
            float y = 300.0f;
            for (int i = 0; i < this.buttons.size(); ++i) {
                Button b = this.buttons.get(i);
                boolean selected = i == this.selectedButton;
                Image image = selected ? b.selected : b.normal;
                g.drawImage(image, x, y);
                y += (float)image.getHeight();
            }
        } else if (this.state == State.controls) {
            g.drawImage(this.controls, 0.0f, 0.0f);
        } else if (this.state == State.start) {
            g.drawImage(this.intro, 0.0f, 0.0f);
        }
    }

    public int getID() {
        return LudumDareGameState.title.ordinal();
    }

    private void addButton(String normalImageId, String selectedImageId, State state) throws SlickException {
        this.buttons.add(new Button(this.load(normalImageId), this.load(selectedImageId), state));
    }

    private Image load(String imageId) throws SlickException {
        return new Image("assets/graphics/" + imageId + ".png", false, 2);
    }

    private static class Button {
        public final Image normal;
        public final Image selected;
        public final State state;

        public Button(Image normal, Image selected, State state) {
            this.normal = normal;
            this.selected = selected;
            this.state = state;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        menu,
        start,
        controls,
        quit;

    }
}

