/*
 * Decompiled with CFR 0.152.
 */
package game.engine;

import game.engine.BaseEntity;
import game.engine.BoundingBox;
import game.engine.GameCamera;
import game.engine.input.MouseEvent;
import game.engine.input.MouseManager;
import game.engine.loader.EntityLoader;
import game.engine.spatial.SpatialQueryManager;
import game.engine.util.ObjectListener;
import game.engine.util.ObjectManager;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.geom.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseGameWorld<GameEntity extends BaseEntity> {
    protected final Random random = new Random();
    protected final EntityLoader loader;
    protected final ObjectManager<GameEntity> objects;
    protected final GameCamera camera;
    private final MouseManager mouseManager;
    private List<GameEntity> cachedRenderList;
    private SpatialQueryManager spatialManager;

    public BaseGameWorld(EntityLoader loader, GameContainer container, GameCamera camera, Class<GameEntity> entityClass) {
        this.loader = loader;
        this.camera = camera;
        this.camera.init(container.getWidth(), container.getHeight());
        this.objects = new ObjectManager<GameEntity>(entityClass);
        this.objects.addListener(new ObjectListener<GameEntity>(){

            @Override
            public void onAdd(GameEntity entity) {
                BaseGameWorld.this.onEntityAdded(entity);
            }

            @Override
            public void onRemove(GameEntity entity) {
                BaseGameWorld.this.onEntityRemoved(entity);
            }
        });
        this.mouseManager = new MouseManager(container.getInput());
        this.cachedRenderList = Collections.emptyList();
        this.spatialManager = new SpatialQueryManager();
    }

    protected void internalUpdate(int dt) {
        this.cachedRenderList = this.objects.get();
        Collections.sort(this.cachedRenderList, new Comparator<GameEntity>(){

            @Override
            public int compare(GameEntity a, GameEntity b) {
                return ((BaseEntity)a).compareRenderOrder((BaseEntity)b);
            }
        });
        this.camera.update(dt);
        for (MouseEvent event : this.mouseManager.takeEvents()) {
            if (event.consumed()) continue;
            BoundingBox bb = this.getCamera().getScreenBounds();
            Vector2f v = this.getCamera().getScreenPos();
            MouseEvent localEvent = event.localized(-bb.getMinX(v), -bb.getMinY(v), bb.getWidth(), bb.getHeight(), this.getCamera().getScale());
            this.onMouseEvent(localEvent);
        }
    }

    protected List<GameEntity> getRenderList() {
        return this.cachedRenderList;
    }

    public GameCamera getCamera() {
        return this.camera;
    }

    public Random getRandom() {
        return this.random;
    }

    public EntityLoader getLoader() {
        return this.loader;
    }

    public SpatialQueryManager getSpatialManager() {
        return this.spatialManager;
    }

    protected abstract void onMouseEvent(MouseEvent var1);

    protected abstract void onEntityAdded(GameEntity var1);

    protected abstract void onEntityRemoved(GameEntity var1);
}

