/*
 * Decompiled with CFR 0.152.
 */
package game.engine;

import org.newdawn.slick.Graphics;
import org.newdawn.slick.geom.Vector2f;

public class BoundingBox {
    private final float ox;
    private final float oy;
    private final float w;
    private final float h;

    public BoundingBox(float w, float h) {
        this.ox = 0.0f;
        this.oy = 0.0f;
        this.w = w;
        this.h = h;
    }

    public BoundingBox(float ox, float oy, float w, float h) {
        this.ox = ox;
        this.oy = oy;
        this.w = w;
        this.h = h;
    }

    public float getMinX(Vector2f at) {
        return this.getMinX(at.x, at.y);
    }

    public float getMinX(float x, float y) {
        return x + this.ox;
    }

    public float getMinY(Vector2f at) {
        return this.getMinY(at.x, at.y);
    }

    public float getMinY(float x, float y) {
        return y + this.oy;
    }

    public float getMaxX(Vector2f at) {
        return this.getMaxX(at.x, at.y);
    }

    public float getMaxX(float x, float y) {
        return x + this.ox + this.w;
    }

    public float getMaxY(Vector2f at) {
        return this.getMaxY(at.x, at.y);
    }

    public float getMaxY(float x, float y) {
        return y + this.oy + this.h;
    }

    public float getCenterX(Vector2f at) {
        return this.getCenterX(at.x, at.y);
    }

    public float getCenterX(float x, float y) {
        return x + this.ox + 0.5f * this.w;
    }

    public float getCenterY(Vector2f at) {
        return this.getCenterY(at.x, at.y);
    }

    public float getCenterY(float x, float y) {
        return y + this.oy + 0.5f * this.h;
    }

    public float getWidth() {
        return this.w;
    }

    public float getHeight() {
        return this.h;
    }

    public boolean intersects(Vector2f at1, BoundingBox other, Vector2f at2) {
        return this.intersects(at1.x, at1.y, other, at2.x, at2.y);
    }

    public boolean intersects(float x1, float y1, BoundingBox other, float x2, float y2) {
        if (this.getMinX(x1, y1) > other.getMaxX(x2, y2) || this.getMaxX(x1, y1) < other.getMinX(x2, y2)) {
            return false;
        }
        return !(this.getMinY(x1, y1) > other.getMaxY(x2, y2)) && !(this.getMaxY(x1, y1) < other.getMinY(x2, y2));
    }

    public boolean contains(Vector2f at1, BoundingBox other, Vector2f at2) {
        return this.contains(at1.x, at1.y, other, at2.x, at2.y);
    }

    public boolean contains(float x1, float y1, BoundingBox other, float x2, float y2) {
        return this.getMinX(x1, y1) <= other.getMinX(x2, y2) && this.getMinY(x1, y1) <= other.getMinY(x2, y2) && this.getMaxX(x1, y1) >= other.getMaxX(x2, y2) && this.getMaxY(x1, y1) >= other.getMaxY(x2, y2);
    }

    public boolean contains(Vector2f at, float px, float py) {
        return this.contains(at.x, at.y, px, py);
    }

    public boolean contains(Vector2f at, Vector2f p) {
        return this.contains(at.x, at.y, p.x, p.y);
    }

    public boolean contains(float x1, float y1, float px, float py) {
        return px >= this.getMinX(x1, y1) && px <= this.getMaxX(x1, y1) && py >= this.getMinY(x1, y1) && py <= this.getMaxY(x1, y1);
    }

    public void draw(Graphics g, Vector2f p) {
        this.draw(g, p.x, p.y);
    }

    public void draw(Graphics g, float x, float y) {
        g.fillRect(this.getMinX(x, y), this.getMinY(x, y), this.getWidth(), this.getHeight());
    }

    public BoundingBox clone() {
        BoundingBox ret = new BoundingBox(this.ox, this.oy, this.w, this.h);
        return ret;
    }
}

