/*
 * Decompiled with CFR 0.152.
 */
package game.engine;

import game.engine.BaseEntity;
import game.engine.BoundingBox;
import game.engine.GameCamera;
import game.engine.util.MathUtil;
import java.util.ArrayList;
import org.newdawn.slick.geom.Vector2f;

public class KeepInViewCamera
extends GameCamera {
    private ArrayList<BaseEntity> entities = new ArrayList();
    private float margin = 0.0f;
    private float minScale = 0.001f;
    private float maxScale = Float.MAX_VALUE;

    public void addEntity(BaseEntity entity) {
        this.entities.add(entity);
    }

    public void setMargin(float margin) {
        this.margin = margin;
    }

    public void setScaleLimits(float min, float max) {
        this.minScale = min;
        this.maxScale = max;
    }

    public void update(int dt) {
        if (!this.entities.isEmpty()) {
            Vector2f min = new Vector2f(Float.MAX_VALUE, Float.MAX_VALUE);
            Vector2f max = new Vector2f(-3.4028235E38f, -3.4028235E38f);
            for (BaseEntity e : this.entities) {
                Vector2f pos = e.getPos();
                BoundingBox bb = e.getBounds();
                min.x = Math.min(min.x, bb.getMinX(pos));
                min.y = Math.min(min.y, bb.getMinY(pos));
                max.x = Math.max(max.x, bb.getMaxX(pos));
                max.y = Math.max(max.y, bb.getMaxY(pos));
            }
            min.x -= this.margin;
            min.y -= this.margin;
            max.x += this.margin;
            max.y += this.margin;
            Vector2f ss = this.getScreenSize();
            this.scale = Math.min(ss.x / (max.x - min.x), ss.y / (max.y - min.y));
            this.scale = MathUtil.clamp(this.scale, this.minScale, this.maxScale);
            this.screenPos.set(max.x + min.x, max.y + min.y);
            this.screenPos.scale(0.5f);
            this.updateBounds();
        }
    }
}

