/*
 * Decompiled with CFR 0.152.
 */
package game.engine.config;

import game.engine.config.ConfigException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigLoader {
    public static void loadArgs(Object config, String[] args) throws ConfigException {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.startsWith("--")) {
                String field = arg.substring(2);
                if (ConfigLoader.hasField(config, field)) {
                    String next;
                    Class<?> fieldType = ConfigLoader.getFieldType(config, field);
                    boolean isBool = fieldType.equals(Boolean.TYPE) || fieldType.equals(Boolean.class);
                    boolean hasNext = i + 1 < args.length;
                    String string = next = hasNext ? args[i + 1] : null;
                    if (isBool) {
                        if (hasNext && ConfigLoader.isValidBoolean(next)) {
                            ConfigLoader.set(config, field, next);
                            ++i;
                            continue;
                        }
                        ConfigLoader.set(config, field, "true");
                        continue;
                    }
                    if (hasNext) {
                        ConfigLoader.set(config, field, next);
                        ++i;
                        continue;
                    }
                    throw new ConfigException("Argument " + arg + " expects a value.");
                }
                throw new ConfigException("Unknown config field \"" + field + "\".");
            }
            throw new ConfigException("Expected an option in the form of \"--name value\", but found \"" + arg + "\"");
        }
    }

    private static boolean isValidBoolean(String s) {
        try {
            Integer.parseInt(s);
            return true;
        }
        catch (NumberFormatException e) {
            return s.equalsIgnoreCase("true") || s.equalsIgnoreCase("false") || s.equalsIgnoreCase("yes") || s.equalsIgnoreCase("no");
        }
    }

    public static void loadProperties(Object config, InputStream in) throws IOException, ConfigException {
        Properties properties = new Properties();
        properties.load(in);
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            ConfigLoader.set(config, entry.getKey().toString(), entry.getValue().toString());
        }
    }

    private static void set(Object config, String fieldName, String value) throws ConfigException {
        Field field = ConfigLoader.getField(config, fieldName);
        Class<?> fieldType = field.getType();
        try {
            Object valueObject = ConfigLoader.parseValue(value, fieldType);
            if (valueObject == null) {
                throw new ConfigException("Cannot parse \"" + value + "\" as a " + fieldType.getSimpleName() + ".");
            }
            field.set(config, valueObject);
        }
        catch (IllegalArgumentException e) {
            throw new ConfigException("The value \"" + value + "\" is not a valid value for field " + fieldName + " of type " + fieldType.getSimpleName());
        }
        catch (IllegalAccessException e) {
            throw new ConfigException("The field " + fieldName + " cannot be set from the config loader.");
        }
    }

    private static Object parseValue(String value, Class<?> type) throws ConfigException {
        try {
            if (type.equals(String.class)) {
                return value;
            }
            if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
                return Integer.parseInt(value);
            }
            if (type.equals(Boolean.TYPE) || type.equals(Boolean.class)) {
                boolean ret;
                try {
                    int intValue = Integer.parseInt(value);
                    ret = intValue != 0;
                }
                catch (NumberFormatException e) {
                    ret = value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes");
                }
                return ret;
            }
            if (type.equals(Float.TYPE) || type.equals(Float.class)) {
                return Float.valueOf(Float.parseFloat(value));
            }
            throw new RuntimeException("Cannot handle config variables of type " + type.getSimpleName() + ".");
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static boolean hasField(Object config, String field) {
        return ConfigLoader.getField(config, field) != null;
    }

    private static Class<?> getFieldType(Object config, String field) {
        return ConfigLoader.getField(config, field).getType();
    }

    private static Field getField(Object config, String field) {
        try {
            return config.getClass().getField(field);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
        catch (SecurityException e) {
            return null;
        }
    }
}

