/*
 * Decompiled with CFR 0.152.
 */
package game.engine.path;

import game.engine.path.Edge;
import game.engine.path.Node;
import game.engine.path.Triangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import org.newdawn.slick.geom.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AStarPathFinder {
    private Triangle[] nodes;

    public AStarPathFinder(Triangle[] nodes) {
        this.nodes = nodes;
    }

    public Vector2f[] findPath(Vector2f from, Vector2f to) {
        Triangle origin = null;
        Triangle target = null;
        for (Triangle t : this.nodes) {
            if (t.inside(from)) {
                origin = t;
            }
            if (!t.inside(to)) continue;
            target = t;
        }
        if (origin == null) {
            return null;
        }
        if (target == null) {
            return null;
        }
        if (origin == target) {
            return new Vector2f[]{new Vector2f(to)};
        }
        HashSet<Node> closedList = new HashSet<Node>();
        LinkedList<Node> openList = new LinkedList<Node>();
        for (int i = 0; i < origin.edges.length; ++i) {
            Edge edge = origin.edges[i];
            Node node = new Node(null, edge);
            node.g = edge.distance(from);
            node.h = edge.distance(to);
            openList.add(node);
        }
        Node node = null;
        while (!openList.isEmpty()) {
            Collections.sort(openList, new Node.Comp());
            node = (Node)openList.removeFirst();
            closedList.add(node);
            if (node.e.owners.contains(target)) break;
            for (Triangle linkedTriangle : node.e.owners) {
                for (Edge linked : linkedTriangle.edges) {
                    Node neighborNode = new Node(node, linked);
                    neighborNode.g = node.g + node.e.distance(neighborNode.e);
                    neighborNode.h = node.e.distance(to);
                    if (closedList.contains(neighborNode)) continue;
                    boolean found = false;
                    for (Node n : openList) {
                        if (!n.equals(neighborNode)) continue;
                        if (neighborNode.g < n.g) {
                            n.g = neighborNode.g;
                            n.parent = neighborNode.parent;
                        }
                        found = true;
                        break;
                    }
                    if (found) continue;
                    openList.add(neighborNode);
                }
            }
        }
        if (node.e.owners.contains(target)) {
            ArrayList<Edge> path = new ArrayList<Edge>();
            while (node != null) {
                path.add(node.e);
                node = node.parent;
            }
            Collections.reverse(path);
            float[] edgePositions = this.optimizeEdgePositions(path, from, to);
            ArrayList<Vector2f> ret = new ArrayList<Vector2f>();
            for (int i = 0; i < edgePositions.length; ++i) {
                Vector2f pos = new Vector2f();
                pos.x = path.get(i).getX(edgePositions[i]);
                pos.y = path.get(i).getY(edgePositions[i]);
                ret.add(pos);
            }
            ret.add(to);
            return ret.toArray(new Vector2f[0]);
        }
        return null;
    }

    private float[] optimizeEdgePositions(ArrayList<Edge> path, Vector2f from, Vector2f to) {
        float[] ret = new float[path.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = 0.5f;
        }
        Vector2f max = new Vector2f();
        Vector2f min = new Vector2f();
        Vector2f previous = new Vector2f();
        Vector2f next = new Vector2f();
        Vector2f current = new Vector2f();
        Vector2f deltaEdge = new Vector2f();
        Vector2f deltaLine = new Vector2f();
        Vector2f delta = new Vector2f();
        for (int n = 0; n < 5; ++n) {
            current.set(from);
            next.set(path.get(0).getX(ret[0]), path.get(0).getY(ret[0]));
            for (int i = 0; i < ret.length; ++i) {
                previous.set(current);
                current.set(next);
                if (i == ret.length - 1) {
                    next.set(to);
                } else {
                    next.set(path.get(i + 1).getX(ret[i + 1]), path.get(i + 1).getY(ret[i + 1]));
                }
                max.set(path.get(i).getX(1.0f), path.get(i).getY(1.0f));
                min.set(path.get(i).getX(0.0f), path.get(i).getY(0.0f));
                deltaLine.set(next);
                deltaLine.sub(previous);
                deltaEdge.set(max);
                deltaEdge.sub(min);
                delta.set(previous);
                delta.sub(min);
                float cross1 = delta.x * deltaLine.y - delta.y * deltaLine.x;
                float cross2 = deltaEdge.x * deltaLine.y - deltaEdge.y * deltaLine.x;
                ret[i] = cross1 / cross2;
                current.set(path.get(i).getX(ret[i]), path.get(i).getY(ret[i]));
            }
        }
        return ret;
    }
}

