/*
 * Decompiled with CFR 0.152.
 */
package game.engine.path;

import game.engine.path.Triangle;
import game.engine.path.Vertex;
import game.engine.util.MathUtil;
import java.util.HashSet;
import java.util.Set;
import org.newdawn.slick.geom.Vector2f;

public class Edge {
    public final Vertex start;
    public final Vertex end;
    public final Set<Triangle> owners = new HashSet<Triangle>();

    public Edge(Vertex start, Vertex end) {
        this.start = start;
        this.end = end;
    }

    public boolean equals(Edge e) {
        return this.start == e.start && this.end == e.end || this.start == e.end && this.end == e.start;
    }

    public boolean equals(Vertex start, Vertex end) {
        return start == this.start && end == this.end || start == this.end && end == this.start;
    }

    public float distance(Vector2f v) {
        return this.distance(v.x, v.y);
    }

    public float distance(Edge e) {
        return this.distance(e.midX(), e.midY());
    }

    public float distance(float x, float y) {
        float dx = x - this.midX();
        float dy = y - this.midY();
        return MathUtil.sqrtf(dx * dx + dy * dy);
    }

    public float midX() {
        return (this.start.x + this.end.x) / 2.0f;
    }

    public float midY() {
        return (this.start.y + this.end.y) / 2.0f;
    }

    public float getX(float t) {
        return t * this.start.x + (1.0f - t) * this.end.x;
    }

    public float getY(float t) {
        return t * this.start.y + (1.0f - t) * this.end.y;
    }
}

